/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractHasherTest;
import org.apache.commons.collections4.bloomfilter.EnhancedDoubleHasher;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.NullHasher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnhancedDoubleHasherTest
extends AbstractHasherTest {
    int[] expected = new int[]{1, 0, 0, 2, 7, 16, 30, 50, 5, 40, 12, 66, 59, 64, 10, 42, 17};

    @Override
    protected Hasher createEmptyHasher() {
        return NullHasher.INSTANCE;
    }

    @Override
    protected Hasher createHasher() {
        return new EnhancedDoubleHasher(1L, 1L);
    }

    @Override
    protected int getAsIndexArrayBehaviour() {
        return 0;
    }

    @Override
    protected int[] getExpectedIndices() {
        return this.expected;
    }

    @Override
    protected int getHasherSize(Hasher hasher) {
        return 1;
    }

    @Test
    public void testByteConstructor() {
        EnhancedDoubleHasher hasher = new EnhancedDoubleHasher(new byte[]{1});
        Assertions.assertEquals((long)0L, (long)hasher.getInitial());
        Assertions.assertEquals((long)0x100000000000000L, (long)hasher.getIncrement());
        hasher = new EnhancedDoubleHasher(new byte[]{1, 2});
        Assertions.assertEquals((long)0x100000000000000L, (long)hasher.getInitial());
        Assertions.assertEquals((long)0x200000000000000L, (long)hasher.getIncrement());
        hasher = new EnhancedDoubleHasher(new byte[]{1, 2, 3});
        Assertions.assertEquals((long)0x100000000000000L, (long)hasher.getInitial());
        Assertions.assertEquals((long)0x203000000000000L, (long)hasher.getIncrement());
        hasher = new EnhancedDoubleHasher(new byte[]{0, 1, 0, 2});
        Assertions.assertEquals((long)0x1000000000000L, (long)hasher.getInitial());
        Assertions.assertEquals((long)0x2000000000000L, (long)hasher.getIncrement());
        hasher = new EnhancedDoubleHasher(new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2});
        Assertions.assertEquals((long)1L, (long)hasher.getInitial());
        Assertions.assertEquals((long)2L, (long)hasher.getIncrement());
        hasher = new EnhancedDoubleHasher(new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 5, 5, 0, 0, 0, 0, 0, 0, 0, 2, 5, 5});
        Assertions.assertEquals((long)1L, (long)hasher.getInitial());
        Assertions.assertEquals((long)2L, (long)hasher.getIncrement());
        hasher = new EnhancedDoubleHasher(new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 5, 1, 0, 0, 0, 0, 0, 0, 2, 5, 5});
        Assertions.assertEquals((long)1L, (long)hasher.getInitial());
        Assertions.assertEquals((long)0x100000000000002L, (long)hasher.getIncrement());
        Assertions.assertThrows(IllegalArgumentException.class, () -> new EnhancedDoubleHasher(new byte[0]));
    }
}

