/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Iterator;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.AbstractBagTest;
import org.apache.commons.collections4.bag.CollectionSortedBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractSortedBagTest<T>
extends AbstractBagTest<T> {
    @Override
    public SortedBag<T> getCollection() {
        return (SortedBag)super.getCollection();
    }

    @Override
    public T[] getFullNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 1;
        }
        return elements;
    }

    @Override
    public T[] getOtherNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 2;
        }
        return elements;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public SortedBag<T> makeConfirmedCollection() {
        return new TreeBag();
    }

    @Override
    public SortedBag<T> makeFullCollection() {
        return (SortedBag)super.makeFullCollection();
    }

    @Override
    public abstract SortedBag<T> makeObject();

    @Override
    public void resetEmpty() {
        this.setCollection(CollectionSortedBag.collectionSortedBag(this.makeObject()));
        this.setConfirmed(this.makeConfirmedCollection());
    }

    @Override
    public void resetFull() {
        this.setCollection(CollectionSortedBag.collectionSortedBag(this.makeFullCollection()));
        this.setConfirmed(this.makeConfirmedFullCollection());
    }

    @Override
    public void verify() {
        super.verify();
        Iterator collIter = this.getCollection().iterator();
        Iterator confIter = this.getConfirmed().iterator();
        Object first = null;
        Object last = null;
        while (collIter.hasNext()) {
            last = first == null ? (first = collIter.next()) : collIter.next();
            Assertions.assertEquals(last, confIter.next(), (String)"Element appears to be out of order.");
        }
        if (!this.getCollection().isEmpty()) {
            Assertions.assertEquals(first, (Object)this.getCollection().first(), (String)"Incorrect element returned by first().");
            Assertions.assertEquals(last, (Object)this.getCollection().last(), (String)"Incorrect element returned by last().");
        }
    }
}

