/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.bag.CollectionBag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractBagTest<T>
extends AbstractCollectionTest<T> {
    public BulkTest bulkTestBagUniqueSet() {
        return new TestBagUniqueSet();
    }

    @Override
    public Bag<T> getCollection() {
        return (Bag)super.getCollection();
    }

    @Override
    public Collection<T> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<T> makeConfirmedFullCollection() {
        Collection<T> coll = this.makeConfirmedCollection();
        coll.addAll(Arrays.asList(this.getFullElements()));
        return coll;
    }

    @Override
    public Bag<T> makeFullCollection() {
        Bag<T> bag = this.makeObject();
        bag.addAll(Arrays.asList(this.getFullElements()));
        return bag;
    }

    @Override
    public abstract Bag<T> makeObject();

    @Override
    public void resetEmpty() {
        this.setCollection(CollectionBag.collectionBag(this.makeObject()));
        this.setConfirmed(this.makeConfirmedCollection());
    }

    @Override
    public void resetFull() {
        this.setCollection(CollectionBag.collectionBag(this.makeFullCollection()));
        this.setConfirmed(this.makeConfirmedFullCollection());
    }

    @Test
    public void testBagAdd() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        Assertions.assertTrue((boolean)bag.contains((Object)"A"), (String)"Should contain 'A'");
        Assertions.assertEquals((int)1, (int)bag.getCount((Object)"A"), (String)"Should have count of 1");
        bag.add((Object)"A");
        Assertions.assertTrue((boolean)bag.contains((Object)"A"), (String)"Should contain 'A'");
        Assertions.assertEquals((int)2, (int)bag.getCount((Object)"A"), (String)"Should have count of 2");
        bag.add((Object)"B");
        Assertions.assertTrue((boolean)bag.contains((Object)"A"));
        Assertions.assertTrue((boolean)bag.contains((Object)"B"));
    }

    @Test
    public void testBagContains() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        Assertions.assertFalse((boolean)bag.contains((Object)"A"), (String)"Bag does not have at least 1 'A'");
        Assertions.assertFalse((boolean)bag.contains((Object)"B"), (String)"Bag does not have at least 1 'B'");
        bag.add((Object)"A");
        Assertions.assertTrue((boolean)bag.contains((Object)"A"), (String)"Bag has at least 1 'A'");
        Assertions.assertFalse((boolean)bag.contains((Object)"B"), (String)"Bag does not have at least 1 'B'");
        bag.add((Object)"A");
        Assertions.assertTrue((boolean)bag.contains((Object)"A"), (String)"Bag has at least 1 'A'");
        Assertions.assertFalse((boolean)bag.contains((Object)"B"), (String)"Bag does not have at least 1 'B'");
        bag.add((Object)"B");
        Assertions.assertTrue((boolean)bag.contains((Object)"A"), (String)"Bag has at least 1 'A'");
        Assertions.assertTrue((boolean)bag.contains((Object)"B"), (String)"Bag has at least 1 'B'");
    }

    @Test
    public void testBagContainsAll() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        ArrayList known = new ArrayList();
        ArrayList<String> known1A = new ArrayList<String>();
        known1A.add("A");
        ArrayList<String> known2A = new ArrayList<String>();
        known2A.add("A");
        known2A.add("A");
        ArrayList<String> known1B = new ArrayList<String>();
        known1B.add("B");
        ArrayList<String> known1A1B = new ArrayList<String>();
        known1A1B.add("A");
        known1A1B.add("B");
        Assertions.assertTrue((boolean)bag.containsAll(known), (String)"Bag containsAll of empty");
        Assertions.assertFalse((boolean)bag.containsAll(known1A), (String)"Bag does not containsAll of 1 'A'");
        Assertions.assertFalse((boolean)bag.containsAll(known2A), (String)"Bag does not containsAll of 2 'A'");
        Assertions.assertFalse((boolean)bag.containsAll(known1B), (String)"Bag does not containsAll of 1 'B'");
        Assertions.assertFalse((boolean)bag.containsAll(known1A1B), (String)"Bag does not containsAll of 1 'A' 1 'B'");
        bag.add((Object)"A");
        Assertions.assertTrue((boolean)bag.containsAll(known), (String)"Bag containsAll of empty");
        Assertions.assertTrue((boolean)bag.containsAll(known1A), (String)"Bag containsAll of 1 'A'");
        Assertions.assertFalse((boolean)bag.containsAll(known2A), (String)"Bag does not containsAll of 2 'A'");
        Assertions.assertFalse((boolean)bag.containsAll(known1B), (String)"Bag does not containsAll of 1 'B'");
        Assertions.assertFalse((boolean)bag.containsAll(known1A1B), (String)"Bag does not containsAll of 1 'A' 1 'B'");
        bag.add((Object)"A");
        Assertions.assertTrue((boolean)bag.containsAll(known), (String)"Bag containsAll of empty");
        Assertions.assertTrue((boolean)bag.containsAll(known1A), (String)"Bag containsAll of 1 'A'");
        Assertions.assertTrue((boolean)bag.containsAll(known2A), (String)"Bag containsAll of 2 'A'");
        Assertions.assertFalse((boolean)bag.containsAll(known1B), (String)"Bag does not containsAll of 1 'B'");
        Assertions.assertFalse((boolean)bag.containsAll(known1A1B), (String)"Bag does not containsAll of 1 'A' 1 'B'");
        bag.add((Object)"A");
        Assertions.assertTrue((boolean)bag.containsAll(known), (String)"Bag containsAll of empty");
        Assertions.assertTrue((boolean)bag.containsAll(known1A), (String)"Bag containsAll of 1 'A'");
        Assertions.assertTrue((boolean)bag.containsAll(known2A), (String)"Bag containsAll of 2 'A'");
        Assertions.assertFalse((boolean)bag.containsAll(known1B), (String)"Bag does not containsAll of 1 'B'");
        Assertions.assertFalse((boolean)bag.containsAll(known1A1B), (String)"Bag does not containsAll of 1 'A' 1 'B'");
        bag.add((Object)"B");
        Assertions.assertTrue((boolean)bag.containsAll(known), (String)"Bag containsAll of empty");
        Assertions.assertTrue((boolean)bag.containsAll(known1A), (String)"Bag containsAll of 1 'A'");
        Assertions.assertTrue((boolean)bag.containsAll(known2A), (String)"Bag containsAll of 2 'A'");
        Assertions.assertTrue((boolean)bag.containsAll(known1B), (String)"Bag containsAll of 1 'B'");
        Assertions.assertTrue((boolean)bag.containsAll(known1A1B), (String)"Bag containsAll of 1 'A' 1 'B'");
    }

    @Test
    public void testBagEquals() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        Bag<T> bag2 = this.makeObject();
        Assertions.assertEquals(bag, bag2);
        bag.add((Object)"A");
        Assertions.assertNotEquals(bag, bag2);
        bag2.add((Object)"A");
        Assertions.assertEquals(bag, bag2);
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        bag2.add((Object)"A");
        bag2.add((Object)"B");
        bag2.add((Object)"B");
        bag2.add((Object)"C");
        Assertions.assertEquals(bag, bag2);
    }

    @Test
    public void testBagEqualsHashBag() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        HashBag bag2 = new HashBag();
        Assertions.assertEquals(bag, (Object)bag2);
        bag.add((Object)"A");
        Assertions.assertNotEquals(bag, (Object)bag2);
        bag2.add((Object)"A");
        Assertions.assertEquals(bag, (Object)bag2);
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        bag2.add((Object)"A");
        bag2.add((Object)"B");
        bag2.add((Object)"B");
        bag2.add((Object)"C");
        Assertions.assertEquals(bag, (Object)bag2);
    }

    @Test
    public void testBagEqualsSelf() {
        Bag<T> bag = this.makeObject();
        Assertions.assertEquals(bag, bag);
        if (!this.isAddSupported()) {
            return;
        }
        bag.add((Object)"elt");
        Assertions.assertEquals(bag, bag);
        bag.add((Object)"elt");
        Assertions.assertEquals(bag, bag);
        bag.add((Object)"elt2");
        Assertions.assertEquals(bag, bag);
    }

    @Test
    public void testBagHashCode() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        Bag<T> bag2 = this.makeObject();
        Assertions.assertEquals((int)0, (int)bag.hashCode());
        Assertions.assertEquals((int)0, (int)bag2.hashCode());
        Assertions.assertEquals((int)bag.hashCode(), (int)bag2.hashCode());
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        bag2.add((Object)"A");
        bag2.add((Object)"A");
        bag2.add((Object)"B");
        bag2.add((Object)"B");
        bag2.add((Object)"C");
        Assertions.assertEquals((int)bag.hashCode(), (int)bag2.hashCode());
        int total = 0;
        total += "A".hashCode() ^ 2;
        total += "B".hashCode() ^ 2;
        Assertions.assertEquals((int)(total += "C".hashCode() ^ 1), (int)bag.hashCode());
        Assertions.assertEquals((int)total, (int)bag2.hashCode());
    }

    @Test
    public void testBagIterator() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Assertions.assertEquals((int)3, (int)bag.size(), (String)"Bag should have 3 items");
        Iterator i = bag.iterator();
        boolean foundA = false;
        while (i.hasNext()) {
            String element = (String)i.next();
            if (!element.equals("A")) continue;
            if (!foundA) {
                foundA = true;
                continue;
            }
            i.remove();
        }
        Assertions.assertTrue((boolean)bag.contains((Object)"A"), (String)"Bag should still contain 'A'");
        Assertions.assertEquals((int)2, (int)bag.size(), (String)"Bag should have 2 items");
        Assertions.assertEquals((int)1, (int)bag.getCount((Object)"A"), (String)"Bag should have 1 'A'");
    }

    @Test
    public void testBagIteratorFail() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Iterator it = bag.iterator();
        it.next();
        bag.remove((Object)"A");
        Assertions.assertThrows(ConcurrentModificationException.class, () -> it.next());
    }

    @Test
    public void testBagIteratorFailDoubleRemove() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Iterator it = bag.iterator();
        it.next();
        it.next();
        Assertions.assertEquals((int)3, (int)bag.size());
        it.remove();
        Assertions.assertEquals((int)2, (int)bag.size());
        Assertions.assertThrows(IllegalStateException.class, () -> it.remove());
        Assertions.assertEquals((int)2, (int)bag.size());
        it.next();
        it.remove();
        Assertions.assertEquals((int)1, (int)bag.size());
    }

    @Test
    public void testBagIteratorFailNoMore() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Iterator it = bag.iterator();
        it.next();
        it.next();
        it.next();
        Assertions.assertThrows(NoSuchElementException.class, () -> it.next());
    }

    @Test
    public void testBagIteratorRemoveProtectsInvariants() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        Assertions.assertEquals((int)2, (int)bag.size());
        Iterator it = bag.iterator();
        Assertions.assertEquals((Object)"A", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        it.remove();
        Assertions.assertEquals((int)1, (int)bag.size());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"A", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        it.remove();
        Assertions.assertEquals((int)0, (int)bag.size());
        Assertions.assertFalse((boolean)it.hasNext());
        Iterator it2 = bag.iterator();
        Assertions.assertFalse((boolean)it2.hasNext());
    }

    @Test
    public void testBagRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        Assertions.assertEquals((int)1, (int)bag.getCount((Object)"A"), (String)"Should have count of 1");
        bag.remove((Object)"A");
        Assertions.assertEquals((int)0, (int)bag.getCount((Object)"A"), (String)"Should have count of 0");
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"A");
        Assertions.assertEquals((int)4, (int)bag.getCount((Object)"A"), (String)"Should have count of 4");
        bag.remove((Object)"A", 0);
        Assertions.assertEquals((int)4, (int)bag.getCount((Object)"A"), (String)"Should have count of 4");
        bag.remove((Object)"A", 2);
        Assertions.assertEquals((int)2, (int)bag.getCount((Object)"A"), (String)"Should have count of 2");
        bag.remove((Object)"A");
        Assertions.assertEquals((int)0, (int)bag.getCount((Object)"A"), (String)"Should have count of 0");
    }

    @Test
    public void testBagRemoveAll() {
        if (!this.isRemoveSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A", 2);
        Assertions.assertEquals((int)2, (int)bag.getCount((Object)"A"), (String)"Should have count of 2");
        bag.add((Object)"B");
        bag.add((Object)"C");
        Assertions.assertEquals((int)4, (int)bag.size(), (String)"Should have count of 4");
        ArrayList<String> delete = new ArrayList<String>();
        delete.add("A");
        delete.add("B");
        bag.removeAll(delete);
        Assertions.assertEquals((int)1, (int)bag.getCount((Object)"A"), (String)"Should have count of 1");
        Assertions.assertEquals((int)0, (int)bag.getCount((Object)"B"), (String)"Should have count of 0");
        Assertions.assertEquals((int)1, (int)bag.getCount((Object)"C"), (String)"Should have count of 1");
        Assertions.assertEquals((int)2, (int)bag.size(), (String)"Should have count of 2");
    }

    @Test
    public void testBagRetainAll() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        ArrayList<String> retains = new ArrayList<String>();
        retains.add("B");
        retains.add("C");
        bag.retainAll(retains);
        Assertions.assertEquals((int)2, (int)bag.size(), (String)"Should have 2 total items");
    }

    @Test
    public void testBagSize() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        Assertions.assertEquals((int)0, (int)bag.size(), (String)"Should have 0 total items");
        bag.add((Object)"A");
        Assertions.assertEquals((int)1, (int)bag.size(), (String)"Should have 1 total items");
        bag.add((Object)"A");
        Assertions.assertEquals((int)2, (int)bag.size(), (String)"Should have 2 total items");
        bag.add((Object)"A");
        Assertions.assertEquals((int)3, (int)bag.size(), (String)"Should have 3 total items");
        bag.add((Object)"B");
        Assertions.assertEquals((int)4, (int)bag.size(), (String)"Should have 4 total items");
        bag.add((Object)"B");
        Assertions.assertEquals((int)5, (int)bag.size(), (String)"Should have 5 total items");
        bag.remove((Object)"A", 2);
        Assertions.assertEquals((int)1, (int)bag.getCount((Object)"A"), (String)"Should have 1 'A'");
        Assertions.assertEquals((int)3, (int)bag.size(), (String)"Should have 3 total items");
        bag.remove((Object)"B");
        Assertions.assertEquals((int)1, (int)bag.size(), (String)"Should have 1 total item");
    }

    @Test
    public void testBagToArray() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        Object[] array = bag.toArray();
        int a = 0;
        int b = 0;
        int c = 0;
        for (Object element : array) {
            a += element.equals("A") ? 1 : 0;
            b += element.equals("B") ? 1 : 0;
            c += element.equals("C") ? 1 : 0;
        }
        Assertions.assertEquals((int)2, (int)a);
        Assertions.assertEquals((int)2, (int)b);
        Assertions.assertEquals((int)1, (int)c);
    }

    @Test
    public void testBagToArrayPopulate() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        String[] array = (String[])bag.toArray((Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        int a = 0;
        int b = 0;
        int c = 0;
        for (String element : array) {
            a += element.equals("A") ? 1 : 0;
            b += element.equals("B") ? 1 : 0;
            c += element.equals("C") ? 1 : 0;
        }
        Assertions.assertEquals((int)2, (int)a);
        Assertions.assertEquals((int)2, (int)b);
        Assertions.assertEquals((int)1, (int)c);
    }

    @Test
    public void testEmptyBagCompatibility() throws IOException, ClassNotFoundException {
        Bag<T> bag = this.makeObject();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(bag));
            Assertions.assertTrue((boolean)bag2.isEmpty(), (String)"Bag is empty");
            Assertions.assertEquals(bag, (Object)bag2);
        }
    }

    @Test
    public void testFullBagCompatibility() throws IOException, ClassNotFoundException {
        Bag<T> bag = this.makeFullCollection();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(bag));
            Assertions.assertEquals((int)bag.size(), (int)bag2.size(), (String)"Bag is the right size");
            Assertions.assertEquals(bag, (Object)bag2);
        }
    }

    public class TestBagUniqueSet
    extends AbstractSetTest<T> {
        @Override
        public T[] getFullElements() {
            return AbstractBagTest.this.getFullElements();
        }

        @Override
        protected int getIterationBehaviour() {
            return AbstractBagTest.this.getIterationBehaviour();
        }

        @Override
        public T[] getOtherElements() {
            return AbstractBagTest.this.getOtherElements();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return AbstractBagTest.this.isNullSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return false;
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public Set<T> makeFullCollection() {
            return AbstractBagTest.this.makeFullCollection().uniqueSet();
        }

        @Override
        public Set<T> makeObject() {
            return AbstractBagTest.this.makeObject().uniqueSet();
        }

        @Override
        public void resetEmpty() {
            AbstractBagTest.this.resetEmpty();
            this.setCollection(AbstractBagTest.this.getCollection().uniqueSet());
            this.setConfirmed(new HashSet(AbstractBagTest.this.getConfirmed()));
        }

        @Override
        public void resetFull() {
            AbstractBagTest.this.resetFull();
            this.setCollection(AbstractBagTest.this.getCollection().uniqueSet());
            this.setConfirmed(new HashSet(AbstractBagTest.this.getConfirmed()));
        }

        @Override
        public void verify() {
            super.verify();
        }
    }
}

