/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.xslt;

/**
 * Interface for handling {@code xsl:message} and {@code xsl:assert} output from XSLT transformations. Note that the
 * same message handler may be called to process messages emanating from multiple threads. The message consumer must
 * therefore be thread-safe; and the order in which messages are passed to the message handler is not always
 * predictable.
 */
@FunctionalInterface
public interface XsltMessageLogger {

    /**
     * Consumes a message generated by a XSLT transformation.
     *
     * @param message the message generated by the XSLT transformation.
     */
    void accept(String message);
}
