/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import java.util.Collections;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.service.jmx.handler.list.DataKeys;
import org.jolokia.service.jmx.handler.list.DataUpdater;

class NotificationDataUpdater
extends DataUpdater {
    protected NotificationDataUpdater() {
        super(100);
    }

    @Override
    public String getKey() {
        return DataKeys.NOTIFICATIONS.getKey();
    }

    @Override
    public JSONObject extractData(ObjectName pObjectName, MBeanInfo pMBeanInfo, String pNotification) {
        JSONObject notMap = new JSONObject();
        for (MBeanNotificationInfo notInfo : pMBeanInfo.getNotifications()) {
            if (pNotification != null && !notInfo.getName().equals(pNotification)) continue;
            JSONObject map = new JSONObject();
            map.put((Object)DataKeys.NAME.getKey(), (Object)notInfo.getName());
            map.put((Object)DataKeys.DESCRIPTION.getKey(), (Object)notInfo.getDescription());
            String[] types = notInfo.getNotifTypes();
            JSONArray tList = new JSONArray(types.length);
            Collections.addAll(tList, types);
            map.put((Object)DataKeys.TYPES.getKey(), (Object)tList);
            notMap.put((Object)notInfo.getName(), (Object)map);
        }
        return notMap;
    }
}

