/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class AMQPFederationMetrics {
    private final AMQPFederationMetrics parent;
    private static final AtomicLongFieldUpdater<AMQPFederationMetrics> MESSAGES_SENT_UPDATER = AtomicLongFieldUpdater.newUpdater(AMQPFederationMetrics.class, "messagesSent");
    private static final AtomicLongFieldUpdater<AMQPFederationMetrics> MESSAGES_RECEIVED_UPDATER = AtomicLongFieldUpdater.newUpdater(AMQPFederationMetrics.class, "messagesReceived");
    private volatile long messagesSent;
    private volatile long messagesReceived;

    public AMQPFederationMetrics() {
        this(null);
    }

    private AMQPFederationMetrics(AMQPFederationMetrics parent) {
        this.parent = parent;
    }

    public long getMessagesSent() {
        return this.messagesSent;
    }

    public long getMessagesReceived() {
        return this.messagesReceived;
    }

    AMQPFederationMetrics newPolicyMetrics() {
        return new AMQPFederationMetrics(this);
    }

    ConsumerMetrics newConsumerMetrics() {
        return new ConsumerMetrics(this);
    }

    ProducerMetrics newProducerMetrics() {
        return new ProducerMetrics(this);
    }

    private void incrementMessagesSent() {
        MESSAGES_SENT_UPDATER.incrementAndGet(this);
        if (this.parent != null) {
            this.parent.incrementMessagesSent();
        }
    }

    private void incrementMessagesReceived() {
        MESSAGES_RECEIVED_UPDATER.incrementAndGet(this);
        if (this.parent != null) {
            this.parent.incrementMessagesReceived();
        }
    }

    public static class ConsumerMetrics {
        private static final AtomicLongFieldUpdater<ConsumerMetrics> MESSAGES_RECEIVED_UPDATER = AtomicLongFieldUpdater.newUpdater(ConsumerMetrics.class, "messagesReceived");
        private final AMQPFederationMetrics parent;
        private volatile long messagesReceived;

        private ConsumerMetrics(AMQPFederationMetrics parent) {
            this.parent = parent;
        }

        public long getMessagesReceived() {
            return this.messagesReceived;
        }

        public void incrementMessagesReceived() {
            MESSAGES_RECEIVED_UPDATER.incrementAndGet(this);
            this.parent.incrementMessagesReceived();
        }
    }

    public static class ProducerMetrics {
        private static final AtomicLongFieldUpdater<ProducerMetrics> MESSAGES_SENT_UPDATER = AtomicLongFieldUpdater.newUpdater(ProducerMetrics.class, "messagesSent");
        private final AMQPFederationMetrics parent;
        private volatile long messagesSent;

        private ProducerMetrics(AMQPFederationMetrics parent) {
            this.parent = parent;
        }

        public long getMessagesSent() {
            return this.messagesSent;
        }

        public void incrementMessagesSent() {
            MESSAGES_SENT_UPDATER.incrementAndGet(this);
            this.parent.incrementMessagesSent();
        }
    }
}

