﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/appflow/model/DescribeConnectorProfilesResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Appflow::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeConnectorProfilesResult::DescribeConnectorProfilesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DescribeConnectorProfilesResult& DescribeConnectorProfilesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("connectorProfileDetails")) {
    Aws::Utils::Array<JsonView> connectorProfileDetailsJsonList = jsonValue.GetArray("connectorProfileDetails");
    for (unsigned connectorProfileDetailsIndex = 0; connectorProfileDetailsIndex < connectorProfileDetailsJsonList.GetLength();
         ++connectorProfileDetailsIndex) {
      m_connectorProfileDetails.push_back(connectorProfileDetailsJsonList[connectorProfileDetailsIndex].AsObject());
    }
    m_connectorProfileDetailsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
