#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include <argon2.h>

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(int)
/*  1 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(argon2_context *, argon2_type)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 44), // argon2_context *
/*  5 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // argon2_type
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(char const *, void const *, size_t, argon2_type)
/*  8 */ _CFFI_OP(_CFFI_OP_POINTER, 47), // char const *
/*  9 */ _CFFI_OP(_CFFI_OP_POINTER, 51), // void const *
/* 10 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 11 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uint32_t, uint32_t, uint32_t, void const *, size_t, void const *, size_t, void *, size_t, char *, size_t, argon2_type, uint32_t)
/* 14 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 15 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 16 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 17 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 18 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 20 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 21 */ _CFFI_OP(_CFFI_OP_POINTER, 51), // void *
/* 22 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 47), // char *
/* 24 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 25 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 26 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uint8_t * *, size_t)
/* 29 */ _CFFI_OP(_CFFI_OP_POINTER, 41), // uint8_t * *
/* 30 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // uint32_t()(uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, argon2_type)
/* 33 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 34 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 35 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 36 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 37 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION, 51), // void()(uint8_t *, size_t)
/* 41 */ _CFFI_OP(_CFFI_OP_POINTER, 49), // uint8_t *
/* 42 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // argon2_context
/* 45 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // argon2_error_codes
/* 46 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // argon2_version
/* 47 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 48 */ _CFFI_OP(_CFFI_OP_POINTER, 28), // int(*)(uint8_t * *, size_t)
/* 49 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 50 */ _CFFI_OP(_CFFI_OP_POINTER, 40), // void(*)(uint8_t *, size_t)
/* 51 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_ARGON2_OK(unsigned long long *o)
{
  int n = (ARGON2_OK) <= 0;
  *o = (unsigned long long)((ARGON2_OK) | 0);  /* check that ARGON2_OK is an integer */
  return n;
}

static int _cffi_const_ARGON2_OUTPUT_PTR_NULL(unsigned long long *o)
{
  int n = (ARGON2_OUTPUT_PTR_NULL) <= 0;
  *o = (unsigned long long)((ARGON2_OUTPUT_PTR_NULL) | 0);  /* check that ARGON2_OUTPUT_PTR_NULL is an integer */
  return n;
}

static int _cffi_const_ARGON2_OUTPUT_TOO_SHORT(unsigned long long *o)
{
  int n = (ARGON2_OUTPUT_TOO_SHORT) <= 0;
  *o = (unsigned long long)((ARGON2_OUTPUT_TOO_SHORT) | 0);  /* check that ARGON2_OUTPUT_TOO_SHORT is an integer */
  return n;
}

static int _cffi_const_ARGON2_OUTPUT_TOO_LONG(unsigned long long *o)
{
  int n = (ARGON2_OUTPUT_TOO_LONG) <= 0;
  *o = (unsigned long long)((ARGON2_OUTPUT_TOO_LONG) | 0);  /* check that ARGON2_OUTPUT_TOO_LONG is an integer */
  return n;
}

static int _cffi_const_ARGON2_PWD_TOO_SHORT(unsigned long long *o)
{
  int n = (ARGON2_PWD_TOO_SHORT) <= 0;
  *o = (unsigned long long)((ARGON2_PWD_TOO_SHORT) | 0);  /* check that ARGON2_PWD_TOO_SHORT is an integer */
  return n;
}

static int _cffi_const_ARGON2_PWD_TOO_LONG(unsigned long long *o)
{
  int n = (ARGON2_PWD_TOO_LONG) <= 0;
  *o = (unsigned long long)((ARGON2_PWD_TOO_LONG) | 0);  /* check that ARGON2_PWD_TOO_LONG is an integer */
  return n;
}

static int _cffi_const_ARGON2_SALT_TOO_SHORT(unsigned long long *o)
{
  int n = (ARGON2_SALT_TOO_SHORT) <= 0;
  *o = (unsigned long long)((ARGON2_SALT_TOO_SHORT) | 0);  /* check that ARGON2_SALT_TOO_SHORT is an integer */
  return n;
}

static int _cffi_const_ARGON2_SALT_TOO_LONG(unsigned long long *o)
{
  int n = (ARGON2_SALT_TOO_LONG) <= 0;
  *o = (unsigned long long)((ARGON2_SALT_TOO_LONG) | 0);  /* check that ARGON2_SALT_TOO_LONG is an integer */
  return n;
}

static int _cffi_const_ARGON2_AD_TOO_SHORT(unsigned long long *o)
{
  int n = (ARGON2_AD_TOO_SHORT) <= 0;
  *o = (unsigned long long)((ARGON2_AD_TOO_SHORT) | 0);  /* check that ARGON2_AD_TOO_SHORT is an integer */
  return n;
}

static int _cffi_const_ARGON2_AD_TOO_LONG(unsigned long long *o)
{
  int n = (ARGON2_AD_TOO_LONG) <= 0;
  *o = (unsigned long long)((ARGON2_AD_TOO_LONG) | 0);  /* check that ARGON2_AD_TOO_LONG is an integer */
  return n;
}

static int _cffi_const_ARGON2_SECRET_TOO_SHORT(unsigned long long *o)
{
  int n = (ARGON2_SECRET_TOO_SHORT) <= 0;
  *o = (unsigned long long)((ARGON2_SECRET_TOO_SHORT) | 0);  /* check that ARGON2_SECRET_TOO_SHORT is an integer */
  return n;
}

static int _cffi_const_ARGON2_SECRET_TOO_LONG(unsigned long long *o)
{
  int n = (ARGON2_SECRET_TOO_LONG) <= 0;
  *o = (unsigned long long)((ARGON2_SECRET_TOO_LONG) | 0);  /* check that ARGON2_SECRET_TOO_LONG is an integer */
  return n;
}

static int _cffi_const_ARGON2_TIME_TOO_SMALL(unsigned long long *o)
{
  int n = (ARGON2_TIME_TOO_SMALL) <= 0;
  *o = (unsigned long long)((ARGON2_TIME_TOO_SMALL) | 0);  /* check that ARGON2_TIME_TOO_SMALL is an integer */
  return n;
}

static int _cffi_const_ARGON2_TIME_TOO_LARGE(unsigned long long *o)
{
  int n = (ARGON2_TIME_TOO_LARGE) <= 0;
  *o = (unsigned long long)((ARGON2_TIME_TOO_LARGE) | 0);  /* check that ARGON2_TIME_TOO_LARGE is an integer */
  return n;
}

static int _cffi_const_ARGON2_MEMORY_TOO_LITTLE(unsigned long long *o)
{
  int n = (ARGON2_MEMORY_TOO_LITTLE) <= 0;
  *o = (unsigned long long)((ARGON2_MEMORY_TOO_LITTLE) | 0);  /* check that ARGON2_MEMORY_TOO_LITTLE is an integer */
  return n;
}

static int _cffi_const_ARGON2_MEMORY_TOO_MUCH(unsigned long long *o)
{
  int n = (ARGON2_MEMORY_TOO_MUCH) <= 0;
  *o = (unsigned long long)((ARGON2_MEMORY_TOO_MUCH) | 0);  /* check that ARGON2_MEMORY_TOO_MUCH is an integer */
  return n;
}

static int _cffi_const_ARGON2_LANES_TOO_FEW(unsigned long long *o)
{
  int n = (ARGON2_LANES_TOO_FEW) <= 0;
  *o = (unsigned long long)((ARGON2_LANES_TOO_FEW) | 0);  /* check that ARGON2_LANES_TOO_FEW is an integer */
  return n;
}

static int _cffi_const_ARGON2_LANES_TOO_MANY(unsigned long long *o)
{
  int n = (ARGON2_LANES_TOO_MANY) <= 0;
  *o = (unsigned long long)((ARGON2_LANES_TOO_MANY) | 0);  /* check that ARGON2_LANES_TOO_MANY is an integer */
  return n;
}

static int _cffi_const_ARGON2_PWD_PTR_MISMATCH(unsigned long long *o)
{
  int n = (ARGON2_PWD_PTR_MISMATCH) <= 0;
  *o = (unsigned long long)((ARGON2_PWD_PTR_MISMATCH) | 0);  /* check that ARGON2_PWD_PTR_MISMATCH is an integer */
  return n;
}

static int _cffi_const_ARGON2_SALT_PTR_MISMATCH(unsigned long long *o)
{
  int n = (ARGON2_SALT_PTR_MISMATCH) <= 0;
  *o = (unsigned long long)((ARGON2_SALT_PTR_MISMATCH) | 0);  /* check that ARGON2_SALT_PTR_MISMATCH is an integer */
  return n;
}

static int _cffi_const_ARGON2_SECRET_PTR_MISMATCH(unsigned long long *o)
{
  int n = (ARGON2_SECRET_PTR_MISMATCH) <= 0;
  *o = (unsigned long long)((ARGON2_SECRET_PTR_MISMATCH) | 0);  /* check that ARGON2_SECRET_PTR_MISMATCH is an integer */
  return n;
}

static int _cffi_const_ARGON2_AD_PTR_MISMATCH(unsigned long long *o)
{
  int n = (ARGON2_AD_PTR_MISMATCH) <= 0;
  *o = (unsigned long long)((ARGON2_AD_PTR_MISMATCH) | 0);  /* check that ARGON2_AD_PTR_MISMATCH is an integer */
  return n;
}

static int _cffi_const_ARGON2_MEMORY_ALLOCATION_ERROR(unsigned long long *o)
{
  int n = (ARGON2_MEMORY_ALLOCATION_ERROR) <= 0;
  *o = (unsigned long long)((ARGON2_MEMORY_ALLOCATION_ERROR) | 0);  /* check that ARGON2_MEMORY_ALLOCATION_ERROR is an integer */
  return n;
}

static int _cffi_const_ARGON2_FREE_MEMORY_CBK_NULL(unsigned long long *o)
{
  int n = (ARGON2_FREE_MEMORY_CBK_NULL) <= 0;
  *o = (unsigned long long)((ARGON2_FREE_MEMORY_CBK_NULL) | 0);  /* check that ARGON2_FREE_MEMORY_CBK_NULL is an integer */
  return n;
}

static int _cffi_const_ARGON2_ALLOCATE_MEMORY_CBK_NULL(unsigned long long *o)
{
  int n = (ARGON2_ALLOCATE_MEMORY_CBK_NULL) <= 0;
  *o = (unsigned long long)((ARGON2_ALLOCATE_MEMORY_CBK_NULL) | 0);  /* check that ARGON2_ALLOCATE_MEMORY_CBK_NULL is an integer */
  return n;
}

static int _cffi_const_ARGON2_INCORRECT_PARAMETER(unsigned long long *o)
{
  int n = (ARGON2_INCORRECT_PARAMETER) <= 0;
  *o = (unsigned long long)((ARGON2_INCORRECT_PARAMETER) | 0);  /* check that ARGON2_INCORRECT_PARAMETER is an integer */
  return n;
}

static int _cffi_const_ARGON2_INCORRECT_TYPE(unsigned long long *o)
{
  int n = (ARGON2_INCORRECT_TYPE) <= 0;
  *o = (unsigned long long)((ARGON2_INCORRECT_TYPE) | 0);  /* check that ARGON2_INCORRECT_TYPE is an integer */
  return n;
}

static int _cffi_const_ARGON2_OUT_PTR_MISMATCH(unsigned long long *o)
{
  int n = (ARGON2_OUT_PTR_MISMATCH) <= 0;
  *o = (unsigned long long)((ARGON2_OUT_PTR_MISMATCH) | 0);  /* check that ARGON2_OUT_PTR_MISMATCH is an integer */
  return n;
}

static int _cffi_const_ARGON2_THREADS_TOO_FEW(unsigned long long *o)
{
  int n = (ARGON2_THREADS_TOO_FEW) <= 0;
  *o = (unsigned long long)((ARGON2_THREADS_TOO_FEW) | 0);  /* check that ARGON2_THREADS_TOO_FEW is an integer */
  return n;
}

static int _cffi_const_ARGON2_THREADS_TOO_MANY(unsigned long long *o)
{
  int n = (ARGON2_THREADS_TOO_MANY) <= 0;
  *o = (unsigned long long)((ARGON2_THREADS_TOO_MANY) | 0);  /* check that ARGON2_THREADS_TOO_MANY is an integer */
  return n;
}

static int _cffi_const_ARGON2_MISSING_ARGS(unsigned long long *o)
{
  int n = (ARGON2_MISSING_ARGS) <= 0;
  *o = (unsigned long long)((ARGON2_MISSING_ARGS) | 0);  /* check that ARGON2_MISSING_ARGS is an integer */
  return n;
}

static int _cffi_const_ARGON2_ENCODING_FAIL(unsigned long long *o)
{
  int n = (ARGON2_ENCODING_FAIL) <= 0;
  *o = (unsigned long long)((ARGON2_ENCODING_FAIL) | 0);  /* check that ARGON2_ENCODING_FAIL is an integer */
  return n;
}

static int _cffi_const_ARGON2_DECODING_FAIL(unsigned long long *o)
{
  int n = (ARGON2_DECODING_FAIL) <= 0;
  *o = (unsigned long long)((ARGON2_DECODING_FAIL) | 0);  /* check that ARGON2_DECODING_FAIL is an integer */
  return n;
}

static int _cffi_const_ARGON2_THREAD_FAIL(unsigned long long *o)
{
  int n = (ARGON2_THREAD_FAIL) <= 0;
  *o = (unsigned long long)((ARGON2_THREAD_FAIL) | 0);  /* check that ARGON2_THREAD_FAIL is an integer */
  return n;
}

static int _cffi_const_ARGON2_DECODING_LENGTH_FAIL(unsigned long long *o)
{
  int n = (ARGON2_DECODING_LENGTH_FAIL) <= 0;
  *o = (unsigned long long)((ARGON2_DECODING_LENGTH_FAIL) | 0);  /* check that ARGON2_DECODING_LENGTH_FAIL is an integer */
  return n;
}

static int _cffi_const_ARGON2_VERIFY_MISMATCH(unsigned long long *o)
{
  int n = (ARGON2_VERIFY_MISMATCH) <= 0;
  *o = (unsigned long long)((ARGON2_VERIFY_MISMATCH) | 0);  /* check that ARGON2_VERIFY_MISMATCH is an integer */
  return n;
}

static int _cffi_const_Argon2_d(unsigned long long *o)
{
  int n = (Argon2_d) <= 0;
  *o = (unsigned long long)((Argon2_d) | 0);  /* check that Argon2_d is an integer */
  return n;
}

static int _cffi_const_Argon2_i(unsigned long long *o)
{
  int n = (Argon2_i) <= 0;
  *o = (unsigned long long)((Argon2_i) | 0);  /* check that Argon2_i is an integer */
  return n;
}

static int _cffi_const_Argon2_id(unsigned long long *o)
{
  int n = (Argon2_id) <= 0;
  *o = (unsigned long long)((Argon2_id) | 0);  /* check that Argon2_id is an integer */
  return n;
}

static int _cffi_const_ARGON2_VERSION_10(unsigned long long *o)
{
  int n = (ARGON2_VERSION_10) <= 0;
  *o = (unsigned long long)((ARGON2_VERSION_10) | 0);  /* check that ARGON2_VERSION_10 is an integer */
  return n;
}

static int _cffi_const_ARGON2_VERSION_13(unsigned long long *o)
{
  int n = (ARGON2_VERSION_13) <= 0;
  *o = (unsigned long long)((ARGON2_VERSION_13) | 0);  /* check that ARGON2_VERSION_13 is an integer */
  return n;
}

static int _cffi_const_ARGON2_VERSION_NUMBER(unsigned long long *o)
{
  int n = (ARGON2_VERSION_NUMBER) <= 0;
  *o = (unsigned long long)((ARGON2_VERSION_NUMBER) | 0);  /* check that ARGON2_VERSION_NUMBER is an integer */
  return n;
}

static int _cffi_d_argon2_ctx(argon2_context * x0, argon2_type x1)
{
  return argon2_ctx(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_argon2_ctx(PyObject *self, PyObject *args)
{
  argon2_context * x0;
  argon2_type x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "argon2_ctx", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (argon2_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(5), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = argon2_ctx(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_argon2_ctx _cffi_d_argon2_ctx
#endif

static uint32_t _cffi_d_argon2_encodedlen(uint32_t x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, argon2_type x5)
{
  return argon2_encodedlen(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_argon2_encodedlen(PyObject *self, PyObject *args)
{
  uint32_t x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  argon2_type x5;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "argon2_encodedlen", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(5), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = argon2_encodedlen(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_argon2_encodedlen _cffi_d_argon2_encodedlen
#endif

static char const * _cffi_d_argon2_error_message(int x0)
{
  return argon2_error_message(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_argon2_error_message(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = argon2_error_message(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  return pyresult;
}
#else
#  define _cffi_f_argon2_error_message _cffi_d_argon2_error_message
#endif

static int _cffi_d_argon2_hash(uint32_t x0, uint32_t x1, uint32_t x2, void const * x3, size_t x4, void const * x5, size_t x6, void * x7, size_t x8, char * x9, size_t x10, argon2_type x11, uint32_t x12)
{
  return argon2_hash(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_argon2_hash(PyObject *self, PyObject *args)
{
  uint32_t x0;
  uint32_t x1;
  uint32_t x2;
  void const * x3;
  size_t x4;
  void const * x5;
  size_t x6;
  void * x7;
  size_t x8;
  char * x9;
  size_t x10;
  argon2_type x11;
  uint32_t x12;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;
  PyObject *arg12;

  if (!PyArg_UnpackTuple(args, "argon2_hash", 13, 13, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11, &arg12))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x8 = _cffi_to_c_int(arg8, size_t);
  if (x8 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x10 = _cffi_to_c_int(arg10, size_t);
  if (x10 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x11, _cffi_type(5), arg11) < 0)
    return NULL;

  x12 = _cffi_to_c_int(arg12, uint32_t);
  if (x12 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = argon2_hash(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_argon2_hash _cffi_d_argon2_hash
#endif

static int _cffi_d_argon2_verify(char const * x0, void const * x1, size_t x2, argon2_type x3)
{
  return argon2_verify(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_argon2_verify(PyObject *self, PyObject *args)
{
  char const * x0;
  void const * x1;
  size_t x2;
  argon2_type x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "argon2_verify", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(5), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = argon2_verify(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_argon2_verify _cffi_d_argon2_verify
#endif

static int _cffi_const_ARGON2_DEFAULT_FLAGS(unsigned long long *o)
{
  int n = (ARGON2_DEFAULT_FLAGS) <= 0;
  *o = (unsigned long long)((ARGON2_DEFAULT_FLAGS) | 0);  /* check that ARGON2_DEFAULT_FLAGS is an integer */
  return n;
}

static int _cffi_const_ARGON2_FLAG_CLEAR_PASSWORD(unsigned long long *o)
{
  int n = (ARGON2_FLAG_CLEAR_PASSWORD) <= 0;
  *o = (unsigned long long)((ARGON2_FLAG_CLEAR_PASSWORD) | 0);  /* check that ARGON2_FLAG_CLEAR_PASSWORD is an integer */
  return n;
}

static int _cffi_const_ARGON2_FLAG_CLEAR_SECRET(unsigned long long *o)
{
  int n = (ARGON2_FLAG_CLEAR_SECRET) <= 0;
  *o = (unsigned long long)((ARGON2_FLAG_CLEAR_SECRET) | 0);  /* check that ARGON2_FLAG_CLEAR_SECRET is an integer */
  return n;
}

static int _cffi_const_ARGON2_MAX_AD_LENGTH(unsigned long long *o)
{
  int n = (ARGON2_MAX_AD_LENGTH) <= 0;
  *o = (unsigned long long)((ARGON2_MAX_AD_LENGTH) | 0);  /* check that ARGON2_MAX_AD_LENGTH is an integer */
  return n;
}

static int _cffi_const_ARGON2_MAX_LANES(unsigned long long *o)
{
  int n = (ARGON2_MAX_LANES) <= 0;
  *o = (unsigned long long)((ARGON2_MAX_LANES) | 0);  /* check that ARGON2_MAX_LANES is an integer */
  return n;
}

static int _cffi_const_ARGON2_MAX_MEMORY(unsigned long long *o)
{
  int n = (ARGON2_MAX_MEMORY) <= 0;
  *o = (unsigned long long)((ARGON2_MAX_MEMORY) | 0);  /* check that ARGON2_MAX_MEMORY is an integer */
  return n;
}

static int _cffi_const_ARGON2_MAX_MEMORY_BITS(unsigned long long *o)
{
  int n = (ARGON2_MAX_MEMORY_BITS) <= 0;
  *o = (unsigned long long)((ARGON2_MAX_MEMORY_BITS) | 0);  /* check that ARGON2_MAX_MEMORY_BITS is an integer */
  return n;
}

static int _cffi_const_ARGON2_MAX_OUTLEN(unsigned long long *o)
{
  int n = (ARGON2_MAX_OUTLEN) <= 0;
  *o = (unsigned long long)((ARGON2_MAX_OUTLEN) | 0);  /* check that ARGON2_MAX_OUTLEN is an integer */
  return n;
}

static int _cffi_const_ARGON2_MAX_PWD_LENGTH(unsigned long long *o)
{
  int n = (ARGON2_MAX_PWD_LENGTH) <= 0;
  *o = (unsigned long long)((ARGON2_MAX_PWD_LENGTH) | 0);  /* check that ARGON2_MAX_PWD_LENGTH is an integer */
  return n;
}

static int _cffi_const_ARGON2_MAX_SALT_LENGTH(unsigned long long *o)
{
  int n = (ARGON2_MAX_SALT_LENGTH) <= 0;
  *o = (unsigned long long)((ARGON2_MAX_SALT_LENGTH) | 0);  /* check that ARGON2_MAX_SALT_LENGTH is an integer */
  return n;
}

static int _cffi_const_ARGON2_MAX_SECRET(unsigned long long *o)
{
  int n = (ARGON2_MAX_SECRET) <= 0;
  *o = (unsigned long long)((ARGON2_MAX_SECRET) | 0);  /* check that ARGON2_MAX_SECRET is an integer */
  return n;
}

static int _cffi_const_ARGON2_MAX_THREADS(unsigned long long *o)
{
  int n = (ARGON2_MAX_THREADS) <= 0;
  *o = (unsigned long long)((ARGON2_MAX_THREADS) | 0);  /* check that ARGON2_MAX_THREADS is an integer */
  return n;
}

static int _cffi_const_ARGON2_MAX_TIME(unsigned long long *o)
{
  int n = (ARGON2_MAX_TIME) <= 0;
  *o = (unsigned long long)((ARGON2_MAX_TIME) | 0);  /* check that ARGON2_MAX_TIME is an integer */
  return n;
}

static int _cffi_const_ARGON2_MIN_AD_LENGTH(unsigned long long *o)
{
  int n = (ARGON2_MIN_AD_LENGTH) <= 0;
  *o = (unsigned long long)((ARGON2_MIN_AD_LENGTH) | 0);  /* check that ARGON2_MIN_AD_LENGTH is an integer */
  return n;
}

static int _cffi_const_ARGON2_MIN_LANES(unsigned long long *o)
{
  int n = (ARGON2_MIN_LANES) <= 0;
  *o = (unsigned long long)((ARGON2_MIN_LANES) | 0);  /* check that ARGON2_MIN_LANES is an integer */
  return n;
}

static int _cffi_const_ARGON2_MIN_MEMORY(unsigned long long *o)
{
  int n = (ARGON2_MIN_MEMORY) <= 0;
  *o = (unsigned long long)((ARGON2_MIN_MEMORY) | 0);  /* check that ARGON2_MIN_MEMORY is an integer */
  return n;
}

static int _cffi_const_ARGON2_MIN_OUTLEN(unsigned long long *o)
{
  int n = (ARGON2_MIN_OUTLEN) <= 0;
  *o = (unsigned long long)((ARGON2_MIN_OUTLEN) | 0);  /* check that ARGON2_MIN_OUTLEN is an integer */
  return n;
}

static int _cffi_const_ARGON2_MIN_PWD_LENGTH(unsigned long long *o)
{
  int n = (ARGON2_MIN_PWD_LENGTH) <= 0;
  *o = (unsigned long long)((ARGON2_MIN_PWD_LENGTH) | 0);  /* check that ARGON2_MIN_PWD_LENGTH is an integer */
  return n;
}

static int _cffi_const_ARGON2_MIN_SALT_LENGTH(unsigned long long *o)
{
  int n = (ARGON2_MIN_SALT_LENGTH) <= 0;
  *o = (unsigned long long)((ARGON2_MIN_SALT_LENGTH) | 0);  /* check that ARGON2_MIN_SALT_LENGTH is an integer */
  return n;
}

static int _cffi_const_ARGON2_MIN_SECRET(unsigned long long *o)
{
  int n = (ARGON2_MIN_SECRET) <= 0;
  *o = (unsigned long long)((ARGON2_MIN_SECRET) | 0);  /* check that ARGON2_MIN_SECRET is an integer */
  return n;
}

static int _cffi_const_ARGON2_MIN_THREADS(unsigned long long *o)
{
  int n = (ARGON2_MIN_THREADS) <= 0;
  *o = (unsigned long long)((ARGON2_MIN_THREADS) | 0);  /* check that ARGON2_MIN_THREADS is an integer */
  return n;
}

static int _cffi_const_ARGON2_MIN_TIME(unsigned long long *o)
{
  int n = (ARGON2_MIN_TIME) <= 0;
  *o = (unsigned long long)((ARGON2_MIN_TIME) | 0);  /* check that ARGON2_MIN_TIME is an integer */
  return n;
}

static int _cffi_const_ARGON2_SYNC_POINTS(unsigned long long *o)
{
  int n = (ARGON2_SYNC_POINTS) <= 0;
  *o = (unsigned long long)((ARGON2_SYNC_POINTS) | 0);  /* check that ARGON2_SYNC_POINTS is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__argon2_context(argon2_context *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { uint8_t * *tmp = &p->out; (void)tmp; }
  (void)((p->outlen) | 0);  /* check that 'argon2_context.outlen' is an integer */
  { uint8_t * *tmp = &p->pwd; (void)tmp; }
  (void)((p->pwdlen) | 0);  /* check that 'argon2_context.pwdlen' is an integer */
  { uint8_t * *tmp = &p->salt; (void)tmp; }
  (void)((p->saltlen) | 0);  /* check that 'argon2_context.saltlen' is an integer */
  { uint8_t * *tmp = &p->secret; (void)tmp; }
  (void)((p->secretlen) | 0);  /* check that 'argon2_context.secretlen' is an integer */
  { uint8_t * *tmp = &p->ad; (void)tmp; }
  (void)((p->adlen) | 0);  /* check that 'argon2_context.adlen' is an integer */
  (void)((p->t_cost) | 0);  /* check that 'argon2_context.t_cost' is an integer */
  (void)((p->m_cost) | 0);  /* check that 'argon2_context.m_cost' is an integer */
  (void)((p->lanes) | 0);  /* check that 'argon2_context.lanes' is an integer */
  (void)((p->threads) | 0);  /* check that 'argon2_context.threads' is an integer */
  (void)((p->version) | 0);  /* check that 'argon2_context.version' is an integer */
  { int(* *tmp)(uint8_t * *, size_t) = &p->allocate_cbk; (void)tmp; }
  { void(* *tmp)(uint8_t *, size_t) = &p->free_cbk; (void)tmp; }
  (void)((p->flags) | 0);  /* check that 'argon2_context.flags' is an integer */
}
struct _cffi_align__argon2_context { char x; argon2_context y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "ARGON2_AD_PTR_MISMATCH", (void *)_cffi_const_ARGON2_AD_PTR_MISMATCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_AD_TOO_LONG", (void *)_cffi_const_ARGON2_AD_TOO_LONG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_AD_TOO_SHORT", (void *)_cffi_const_ARGON2_AD_TOO_SHORT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_ALLOCATE_MEMORY_CBK_NULL", (void *)_cffi_const_ARGON2_ALLOCATE_MEMORY_CBK_NULL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_DECODING_FAIL", (void *)_cffi_const_ARGON2_DECODING_FAIL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_DECODING_LENGTH_FAIL", (void *)_cffi_const_ARGON2_DECODING_LENGTH_FAIL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_DEFAULT_FLAGS", (void *)_cffi_const_ARGON2_DEFAULT_FLAGS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_ENCODING_FAIL", (void *)_cffi_const_ARGON2_ENCODING_FAIL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_FLAG_CLEAR_PASSWORD", (void *)_cffi_const_ARGON2_FLAG_CLEAR_PASSWORD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_FLAG_CLEAR_SECRET", (void *)_cffi_const_ARGON2_FLAG_CLEAR_SECRET, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_FREE_MEMORY_CBK_NULL", (void *)_cffi_const_ARGON2_FREE_MEMORY_CBK_NULL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_INCORRECT_PARAMETER", (void *)_cffi_const_ARGON2_INCORRECT_PARAMETER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_INCORRECT_TYPE", (void *)_cffi_const_ARGON2_INCORRECT_TYPE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_LANES_TOO_FEW", (void *)_cffi_const_ARGON2_LANES_TOO_FEW, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_LANES_TOO_MANY", (void *)_cffi_const_ARGON2_LANES_TOO_MANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_MAX_AD_LENGTH", (void *)_cffi_const_ARGON2_MAX_AD_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MAX_LANES", (void *)_cffi_const_ARGON2_MAX_LANES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MAX_MEMORY", (void *)_cffi_const_ARGON2_MAX_MEMORY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MAX_MEMORY_BITS", (void *)_cffi_const_ARGON2_MAX_MEMORY_BITS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MAX_OUTLEN", (void *)_cffi_const_ARGON2_MAX_OUTLEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MAX_PWD_LENGTH", (void *)_cffi_const_ARGON2_MAX_PWD_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MAX_SALT_LENGTH", (void *)_cffi_const_ARGON2_MAX_SALT_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MAX_SECRET", (void *)_cffi_const_ARGON2_MAX_SECRET, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MAX_THREADS", (void *)_cffi_const_ARGON2_MAX_THREADS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MAX_TIME", (void *)_cffi_const_ARGON2_MAX_TIME, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MEMORY_ALLOCATION_ERROR", (void *)_cffi_const_ARGON2_MEMORY_ALLOCATION_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_MEMORY_TOO_LITTLE", (void *)_cffi_const_ARGON2_MEMORY_TOO_LITTLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_MEMORY_TOO_MUCH", (void *)_cffi_const_ARGON2_MEMORY_TOO_MUCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_MIN_AD_LENGTH", (void *)_cffi_const_ARGON2_MIN_AD_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MIN_LANES", (void *)_cffi_const_ARGON2_MIN_LANES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MIN_MEMORY", (void *)_cffi_const_ARGON2_MIN_MEMORY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MIN_OUTLEN", (void *)_cffi_const_ARGON2_MIN_OUTLEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MIN_PWD_LENGTH", (void *)_cffi_const_ARGON2_MIN_PWD_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MIN_SALT_LENGTH", (void *)_cffi_const_ARGON2_MIN_SALT_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MIN_SECRET", (void *)_cffi_const_ARGON2_MIN_SECRET, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MIN_THREADS", (void *)_cffi_const_ARGON2_MIN_THREADS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MIN_TIME", (void *)_cffi_const_ARGON2_MIN_TIME, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_MISSING_ARGS", (void *)_cffi_const_ARGON2_MISSING_ARGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_OK", (void *)_cffi_const_ARGON2_OK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_OUTPUT_PTR_NULL", (void *)_cffi_const_ARGON2_OUTPUT_PTR_NULL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_OUTPUT_TOO_LONG", (void *)_cffi_const_ARGON2_OUTPUT_TOO_LONG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_OUTPUT_TOO_SHORT", (void *)_cffi_const_ARGON2_OUTPUT_TOO_SHORT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_OUT_PTR_MISMATCH", (void *)_cffi_const_ARGON2_OUT_PTR_MISMATCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_PWD_PTR_MISMATCH", (void *)_cffi_const_ARGON2_PWD_PTR_MISMATCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_PWD_TOO_LONG", (void *)_cffi_const_ARGON2_PWD_TOO_LONG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_PWD_TOO_SHORT", (void *)_cffi_const_ARGON2_PWD_TOO_SHORT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_SALT_PTR_MISMATCH", (void *)_cffi_const_ARGON2_SALT_PTR_MISMATCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_SALT_TOO_LONG", (void *)_cffi_const_ARGON2_SALT_TOO_LONG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_SALT_TOO_SHORT", (void *)_cffi_const_ARGON2_SALT_TOO_SHORT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_SECRET_PTR_MISMATCH", (void *)_cffi_const_ARGON2_SECRET_PTR_MISMATCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_SECRET_TOO_LONG", (void *)_cffi_const_ARGON2_SECRET_TOO_LONG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_SECRET_TOO_SHORT", (void *)_cffi_const_ARGON2_SECRET_TOO_SHORT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_SYNC_POINTS", (void *)_cffi_const_ARGON2_SYNC_POINTS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARGON2_THREADS_TOO_FEW", (void *)_cffi_const_ARGON2_THREADS_TOO_FEW, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_THREADS_TOO_MANY", (void *)_cffi_const_ARGON2_THREADS_TOO_MANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_THREAD_FAIL", (void *)_cffi_const_ARGON2_THREAD_FAIL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_TIME_TOO_LARGE", (void *)_cffi_const_ARGON2_TIME_TOO_LARGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_TIME_TOO_SMALL", (void *)_cffi_const_ARGON2_TIME_TOO_SMALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_VERIFY_MISMATCH", (void *)_cffi_const_ARGON2_VERIFY_MISMATCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_VERSION_10", (void *)_cffi_const_ARGON2_VERSION_10, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_VERSION_13", (void *)_cffi_const_ARGON2_VERSION_13, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARGON2_VERSION_NUMBER", (void *)_cffi_const_ARGON2_VERSION_NUMBER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "Argon2_d", (void *)_cffi_const_Argon2_d, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "Argon2_i", (void *)_cffi_const_Argon2_i, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "Argon2_id", (void *)_cffi_const_Argon2_id, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "argon2_ctx", (void *)_cffi_f_argon2_ctx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 3), (void *)_cffi_d_argon2_ctx },
  { "argon2_encodedlen", (void *)_cffi_f_argon2_encodedlen, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 32), (void *)_cffi_d_argon2_encodedlen },
  { "argon2_error_message", (void *)_cffi_f_argon2_error_message, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_argon2_error_message },
  { "argon2_hash", (void *)_cffi_f_argon2_hash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 13), (void *)_cffi_d_argon2_hash },
  { "argon2_verify", (void *)_cffi_f_argon2_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 7), (void *)_cffi_d_argon2_verify },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "out", offsetof(argon2_context, out),
           sizeof(((argon2_context *)0)->out),
           _CFFI_OP(_CFFI_OP_NOOP, 41) },
  { "outlen", offsetof(argon2_context, outlen),
              sizeof(((argon2_context *)0)->outlen),
              _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "pwd", offsetof(argon2_context, pwd),
           sizeof(((argon2_context *)0)->pwd),
           _CFFI_OP(_CFFI_OP_NOOP, 41) },
  { "pwdlen", offsetof(argon2_context, pwdlen),
              sizeof(((argon2_context *)0)->pwdlen),
              _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "salt", offsetof(argon2_context, salt),
            sizeof(((argon2_context *)0)->salt),
            _CFFI_OP(_CFFI_OP_NOOP, 41) },
  { "saltlen", offsetof(argon2_context, saltlen),
               sizeof(((argon2_context *)0)->saltlen),
               _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "secret", offsetof(argon2_context, secret),
              sizeof(((argon2_context *)0)->secret),
              _CFFI_OP(_CFFI_OP_NOOP, 41) },
  { "secretlen", offsetof(argon2_context, secretlen),
                 sizeof(((argon2_context *)0)->secretlen),
                 _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "ad", offsetof(argon2_context, ad),
          sizeof(((argon2_context *)0)->ad),
          _CFFI_OP(_CFFI_OP_NOOP, 41) },
  { "adlen", offsetof(argon2_context, adlen),
             sizeof(((argon2_context *)0)->adlen),
             _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "t_cost", offsetof(argon2_context, t_cost),
              sizeof(((argon2_context *)0)->t_cost),
              _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "m_cost", offsetof(argon2_context, m_cost),
              sizeof(((argon2_context *)0)->m_cost),
              _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "lanes", offsetof(argon2_context, lanes),
             sizeof(((argon2_context *)0)->lanes),
             _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "threads", offsetof(argon2_context, threads),
               sizeof(((argon2_context *)0)->threads),
               _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "version", offsetof(argon2_context, version),
               sizeof(((argon2_context *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "allocate_cbk", offsetof(argon2_context, allocate_cbk),
                    sizeof(((argon2_context *)0)->allocate_cbk),
                    _CFFI_OP(_CFFI_OP_NOOP, 48) },
  { "free_cbk", offsetof(argon2_context, free_cbk),
                sizeof(((argon2_context *)0)->free_cbk),
                _CFFI_OP(_CFFI_OP_NOOP, 50) },
  { "flags", offsetof(argon2_context, flags),
             sizeof(((argon2_context *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 14) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "Argon2_Context", 44, _CFFI_F_CHECK_FIELDS,
    sizeof(argon2_context), offsetof(struct _cffi_align__argon2_context, y), 0, 18 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "Argon2_ErrorCodes", 45, _cffi_prim_int(sizeof(argon2_error_codes), ((argon2_error_codes)-1) <= 0),
    "ARGON2_OK,ARGON2_OUTPUT_PTR_NULL,ARGON2_OUTPUT_TOO_SHORT,ARGON2_OUTPUT_TOO_LONG,ARGON2_PWD_TOO_SHORT,ARGON2_PWD_TOO_LONG,ARGON2_SALT_TOO_SHORT,ARGON2_SALT_TOO_LONG,ARGON2_AD_TOO_SHORT,ARGON2_AD_TOO_LONG,ARGON2_SECRET_TOO_SHORT,ARGON2_SECRET_TOO_LONG,ARGON2_TIME_TOO_SMALL,ARGON2_TIME_TOO_LARGE,ARGON2_MEMORY_TOO_LITTLE,ARGON2_MEMORY_TOO_MUCH,ARGON2_LANES_TOO_FEW,ARGON2_LANES_TOO_MANY,ARGON2_PWD_PTR_MISMATCH,ARGON2_SALT_PTR_MISMATCH,ARGON2_SECRET_PTR_MISMATCH,ARGON2_AD_PTR_MISMATCH,ARGON2_MEMORY_ALLOCATION_ERROR,ARGON2_FREE_MEMORY_CBK_NULL,ARGON2_ALLOCATE_MEMORY_CBK_NULL,ARGON2_INCORRECT_PARAMETER,ARGON2_INCORRECT_TYPE,ARGON2_OUT_PTR_MISMATCH,ARGON2_THREADS_TOO_FEW,ARGON2_THREADS_TOO_MANY,ARGON2_MISSING_ARGS,ARGON2_ENCODING_FAIL,ARGON2_DECODING_FAIL,ARGON2_THREAD_FAIL,ARGON2_DECODING_LENGTH_FAIL,ARGON2_VERIFY_MISMATCH" },
  { "Argon2_type", 5, _cffi_prim_int(sizeof(argon2_type), ((argon2_type)-1) <= 0),
    "Argon2_d,Argon2_i,Argon2_id" },
  { "Argon2_version", 46, _cffi_prim_int(sizeof(argon2_version), ((argon2_version)-1) <= 0),
    "ARGON2_VERSION_10,ARGON2_VERSION_13,ARGON2_VERSION_NUMBER" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "allocate_fptr", 48 },
  { "argon2_context", 44 },
  { "argon2_error_codes", 45 },
  { "argon2_type", 5 },
  { "argon2_version", 46 },
  { "deallocate_fptr", 50 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  70,  /* num_globals */
  1,  /* num_struct_unions */
  3,  /* num_enums */
  6,  /* num_typenames */
  NULL,  /* no includes */
  52,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__ffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__ffi(void) { return NULL; }
#  else
     init_ffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__ffi(void)
{
  return _cffi_init("_ffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_ffi(void)
{
  _cffi_init("_ffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
