/*
 * Copyright 2025 The OpenSSL Project Authors. All Rights Reserved.
 *
 * Licensed under the Apache License 2.0 (the "License").  You may not use
 * this file except in compliance with the License.  You can obtain a copy
 * in the file LICENSE in the source distribution or at
 * https://www.openssl.org/source/license.html
 */


#include <string.h>
#include "internal/common.h"

/* Machine generated by util/perl/OpenSSL/paramnames.pm */
#ifndef blake2_get_ctx_list
static const OSSL_PARAM blake2_get_ctx_list[] = {
    OSSL_PARAM_size_t(OSSL_MAC_PARAM_SIZE, NULL),
    OSSL_PARAM_size_t(OSSL_MAC_PARAM_BLOCK_SIZE, NULL),
    OSSL_PARAM_END
};
#endif

#ifndef blake2_get_ctx_st
struct blake2_get_ctx_st {
    OSSL_PARAM *bsize;
    OSSL_PARAM *size;
};
#endif

#ifndef blake2_get_ctx_decoder
static int blake2_get_ctx_decoder
    (const OSSL_PARAM *p, struct blake2_get_ctx_st *r)
{
    const char *s;

    memset(r, 0, sizeof(*r));
    if (p != NULL)
        for (; (s = p->key) != NULL; p++)
            switch(s[0]) {
            default:
                break;
            case 'b':
                if (ossl_likely(strcmp("lock-size", s + 1) == 0)) {
                    /* OSSL_MAC_PARAM_BLOCK_SIZE */
                    if (ossl_unlikely(r->bsize != NULL)) {
                        ERR_raise_data(ERR_LIB_PROV, PROV_R_REPEATED_PARAMETER,
                                       "param %s is repeated", s);
                        return 0;
                    }
                    r->bsize = (OSSL_PARAM *)p;
                }
                break;
            case 's':
                if (ossl_likely(strcmp("ize", s + 1) == 0)) {
                    /* OSSL_MAC_PARAM_SIZE */
                    if (ossl_unlikely(r->size != NULL)) {
                        ERR_raise_data(ERR_LIB_PROV, PROV_R_REPEATED_PARAMETER,
                                       "param %s is repeated", s);
                        return 0;
                    }
                    r->size = (OSSL_PARAM *)p;
                }
            }
    return 1;
}
#endif
/* End of machine generated */

/* Machine generated by util/perl/OpenSSL/paramnames.pm */
#ifndef blake2_mac_set_ctx_list
static const OSSL_PARAM blake2_mac_set_ctx_list[] = {
    OSSL_PARAM_size_t(OSSL_MAC_PARAM_SIZE, NULL),
    OSSL_PARAM_octet_string(OSSL_MAC_PARAM_KEY, NULL, 0),
    OSSL_PARAM_octet_string(OSSL_MAC_PARAM_CUSTOM, NULL, 0),
    OSSL_PARAM_octet_string(OSSL_MAC_PARAM_SALT, NULL, 0),
    OSSL_PARAM_END
};
#endif

#ifndef blake2_mac_set_ctx_st
struct blake2_mac_set_ctx_st {
    OSSL_PARAM *cust;
    OSSL_PARAM *key;
    OSSL_PARAM *salt;
    OSSL_PARAM *size;
};
#endif

#ifndef blake2_mac_set_ctx_decoder
static int blake2_mac_set_ctx_decoder
    (const OSSL_PARAM *p, struct blake2_mac_set_ctx_st *r)
{
    const char *s;

    memset(r, 0, sizeof(*r));
    if (p != NULL)
        for (; (s = p->key) != NULL; p++)
            switch(s[0]) {
            default:
                break;
            case 'c':
                if (ossl_likely(strcmp("ustom", s + 1) == 0)) {
                    /* OSSL_MAC_PARAM_CUSTOM */
                    if (ossl_unlikely(r->cust != NULL)) {
                        ERR_raise_data(ERR_LIB_PROV, PROV_R_REPEATED_PARAMETER,
                                       "param %s is repeated", s);
                        return 0;
                    }
                    r->cust = (OSSL_PARAM *)p;
                }
                break;
            case 'k':
                if (ossl_likely(strcmp("ey", s + 1) == 0)) {
                    /* OSSL_MAC_PARAM_KEY */
                    if (ossl_unlikely(r->key != NULL)) {
                        ERR_raise_data(ERR_LIB_PROV, PROV_R_REPEATED_PARAMETER,
                                       "param %s is repeated", s);
                        return 0;
                    }
                    r->key = (OSSL_PARAM *)p;
                }
                break;
            case 's':
                switch(s[1]) {
                default:
                    break;
                case 'a':
                    if (ossl_likely(strcmp("lt", s + 2) == 0)) {
                        /* OSSL_MAC_PARAM_SALT */
                        if (ossl_unlikely(r->salt != NULL)) {
                            ERR_raise_data(ERR_LIB_PROV, PROV_R_REPEATED_PARAMETER,
                                           "param %s is repeated", s);
                            return 0;
                        }
                        r->salt = (OSSL_PARAM *)p;
                    }
                    break;
                case 'i':
                    if (ossl_likely(strcmp("ze", s + 2) == 0)) {
                        /* OSSL_MAC_PARAM_SIZE */
                        if (ossl_unlikely(r->size != NULL)) {
                            ERR_raise_data(ERR_LIB_PROV, PROV_R_REPEATED_PARAMETER,
                                           "param %s is repeated", s);
                            return 0;
                        }
                        r->size = (OSSL_PARAM *)p;
                    }
                }
            }
    return 1;
}
#endif
/* End of machine generated */
    
