/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.registry.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.registry.api.event.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.registry.consumer.MicroserviceInstancePing;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCache;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableMicroserviceCache
implements MicroserviceCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshableMicroserviceCache.class);
    MicroserviceCacheKey key;
    List<MicroserviceInstance> instances = Collections.unmodifiableList(new ArrayList());
    Microservice consumerService;
    String revisionId;
    ServiceRegistryClient srClient;
    MicroserviceCache.MicroserviceCacheStatus status = MicroserviceCache.MicroserviceCacheStatus.INIT;
    private final Object SET_OPERATION_LOCK = new Object();
    boolean emptyInstanceProtectionEnabled;
    MicroserviceInstancePing instancePing = (MicroserviceInstancePing)SPIServiceUtils.getPriorityHighestService(MicroserviceInstancePing.class);

    RefreshableMicroserviceCache(Microservice consumerService, MicroserviceCacheKey key, ServiceRegistryClient srClient, boolean emptyInstanceProtectionEnabled) {
        this.key = key;
        this.consumerService = consumerService;
        this.srClient = srClient;
        this.emptyInstanceProtectionEnabled = emptyInstanceProtectionEnabled;
    }

    @Override
    public void refresh() {
        this.safePullInstance(this.revisionId);
    }

    @Override
    public void forceRefresh() {
        this.safePullInstance(null);
    }

    void safePullInstance(String revisionId) {
        try {
            this.pullInstance(revisionId);
        }
        catch (Throwable e) {
            LOGGER.error("unknown error occurs while pulling instances", e);
            this.setStatus(MicroserviceCache.MicroserviceCacheStatus.UNKNOWN_ERROR);
        }
    }

    private void pullInstance(String revisionId) {
        MicroserviceInstances serviceInstances = this.pullInstanceFromServiceCenter(revisionId);
        if (serviceInstances == null) {
            LOGGER.error("Can not find any instances from service center due to previous errors. service={}/{}/{}", new Object[]{this.key.getAppId(), this.key.getServiceName(), this.key.getVersionRule()});
            this.setStatus(MicroserviceCache.MicroserviceCacheStatus.CLIENT_ERROR);
            return;
        }
        if (serviceInstances.isMicroserviceNotExist()) {
            this.setStatus(MicroserviceCache.MicroserviceCacheStatus.SERVICE_NOT_FOUND);
            return;
        }
        if (!serviceInstances.isNeedRefresh()) {
            LOGGER.debug("instances revision is not changed, service={}/{}/{}", new Object[]{this.key.getAppId(), this.key.getServiceName(), this.key.getVersionRule()});
            this.setStatus(MicroserviceCache.MicroserviceCacheStatus.NO_CHANGE);
            return;
        }
        List instances = serviceInstances.getInstancesResponse().getInstances();
        LOGGER.info("find instances[{}] from service center success. service={}/{}/{}, old revision={}, new revision={}", new Object[]{instances.size(), this.key.getAppId(), this.key.getServiceName(), this.key.getVersionRule(), revisionId, serviceInstances.getRevision()});
        for (MicroserviceInstance instance : instances) {
            LOGGER.info("service id={}, instance id={}, endpoints={}", new Object[]{instance.getServiceId(), instance.getInstanceId(), instance.getEndpoints()});
        }
        this.safeSetInstances(instances, serviceInstances.getRevision());
    }

    MicroserviceInstances pullInstanceFromServiceCenter(String revisionId) {
        return this.srClient.findServiceInstances(this.consumerService.getServiceId(), this.key.getAppId(), this.key.getServiceName(), this.key.getVersionRule(), revisionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeSetInstances(List<MicroserviceInstance> pulledInstances, String rev) {
        try {
            Object object = this.SET_OPERATION_LOCK;
            synchronized (object) {
                this.setInstances(pulledInstances, rev);
                this.setStatus(MicroserviceCache.MicroserviceCacheStatus.REFRESHED);
            }
        }
        catch (Throwable e) {
            this.setStatus(MicroserviceCache.MicroserviceCacheStatus.SETTING_CACHE_ERROR);
            LOGGER.error("Failed to setInstances, appId={}, microserviceName={}.", new Object[]{this.key.getAppId(), this.key.getServiceName(), e});
        }
    }

    private void setInstances(List<MicroserviceInstance> pulledInstances, String rev) {
        Set<MicroserviceInstance> mergedInstances = this.mergeInstances(pulledInstances);
        LOGGER.debug("actually set instances[{}] for {}", (Object)mergedInstances.size(), (Object)this.key.plainKey());
        for (MicroserviceInstance mergedInstance : mergedInstances) {
            LOGGER.debug("serviceId={}, instanceId={}, endpoints={}", new Object[]{mergedInstance.getServiceId(), mergedInstance.getInstanceId(), mergedInstance.getEndpoints()});
        }
        this.instances = Collections.unmodifiableList(new ArrayList<MicroserviceInstance>(mergedInstances));
        this.revisionId = rev;
    }

    protected Set<MicroserviceInstance> mergeInstances(List<MicroserviceInstance> pulledInstances) {
        LinkedHashSet<MicroserviceInstance> mergedInstances = new LinkedHashSet<MicroserviceInstance>(pulledInstances);
        if (!this.inEmptyPulledInstancesProtectionSituation(pulledInstances)) {
            return mergedInstances;
        }
        if (null == this.instancePing) {
            LOGGER.info("no MicroserviceInstancePing implementation loaded, abandon the old instance list");
            return mergedInstances;
        }
        this.instances.forEach(instance -> {
            if (!mergedInstances.contains(instance) && this.instancePing.ping(instance)) {
                mergedInstances.add((MicroserviceInstance)instance);
            }
        });
        return mergedInstances;
    }

    private boolean inEmptyPulledInstancesProtectionSituation(List<MicroserviceInstance> pulledInstances) {
        return pulledInstances.isEmpty() && this.instances != null && !this.instances.isEmpty() && this.isEmptyInstanceProtectionEnabled();
    }

    @Override
    public MicroserviceCacheKey getKey() {
        return this.key;
    }

    @Override
    public List<MicroserviceInstance> getInstances() {
        return this.instances;
    }

    @Override
    public String getRevisionId() {
        return this.revisionId;
    }

    @Override
    public MicroserviceCache.MicroserviceCacheStatus getStatus() {
        return this.status;
    }

    void setStatus(MicroserviceCache.MicroserviceCacheStatus status) {
        this.status = status;
    }

    boolean isEmptyInstanceProtectionEnabled() {
        return this.emptyInstanceProtectionEnabled;
    }

    void setEmptyInstanceProtectionEnabled(boolean emptyInstanceProtectionEnabled) {
        this.emptyInstanceProtectionEnabled = emptyInstanceProtectionEnabled;
    }

    public boolean isAcceptableEvent(MicroserviceInstanceChangedEvent event) {
        return this.key.getAppId().equals(event.getKey().getAppId()) && (this.key.getServiceName().equals(event.getKey().getServiceName()) || this.key.getServiceName().equals(event.getKey().getAppId() + ":" + event.getKey().getServiceName()));
    }
}

