/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.confignode.consensus.request.write.table.RenameTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.RenameViewColumnPlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.AbstractAlterOrDropTableProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.RenameViewColumnProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.RenameTableColumnState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameTableColumnProcedure
extends AbstractAlterOrDropTableProcedure<RenameTableColumnState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenameTableColumnProcedure.class);
    private String oldName;
    private String newName;

    public RenameTableColumnProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public RenameTableColumnProcedure(String database, String tableName, String queryId, String oldName, String newName, boolean isGeneratedByPipe) {
        super(database, tableName, queryId, isGeneratedByPipe);
        this.oldName = oldName;
        this.newName = newName;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, RenameTableColumnState state) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void columnCheck(ConfigNodeProcedureEnv env) {
        try {
            Pair<TSStatus, TsTable> result = env.getConfigManager().getClusterSchemaManager().tableColumnCheckForColumnRenaming(this.database, this.tableName, this.oldName, this.newName, this instanceof RenameViewColumnProcedure);
            TSStatus status = (TSStatus)result.getLeft();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                this.setFailure(new ProcedureException((Throwable)new IoTDBException(status)));
                return;
            }
            this.table = (TsTable)result.getRight();
            this.setNextState(RenameTableColumnState.PRE_RELEASE);
        }
        catch (MetadataException e) {
            this.setFailure(new ProcedureException(e));
        }
    }

    @Override
    protected void preRelease(ConfigNodeProcedureEnv env) {
        super.preRelease(env);
        this.setNextState(RenameTableColumnState.RENAME_COLUMN);
    }

    private void renameColumn(ConfigNodeProcedureEnv env) {
        TSStatus status = env.getConfigManager().getClusterSchemaManager().executePlan(this instanceof RenameViewColumnProcedure ? new RenameViewColumnPlan(this.database, this.tableName, this.oldName, this.newName) : new RenameTableColumnPlan(this.database, this.tableName, this.oldName, this.newName), this.isGeneratedByPipe);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status)));
        } else {
            this.setNextState(RenameTableColumnState.COMMIT_RELEASE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, RenameTableColumnState state) throws IOException, InterruptedException, ProcedureException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case RENAME_COLUMN: {
                    LOGGER.info("Start rollback Renaming column to table {}.{} on configNode", (Object)this.database, (Object)this.table.getTableName());
                    this.rollbackRenameColumn(env);
                    return;
                }
                case PRE_RELEASE: {
                    LOGGER.info("Start rollback pre release info of table {}.{}", (Object)this.database, (Object)this.table.getTableName());
                    this.rollbackPreRelease(env);
                    return;
                }
            }
            return;
        }
        finally {
            LOGGER.info("Rollback RenameTableColumn-{} costs {}ms.", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void rollbackRenameColumn(ConfigNodeProcedureEnv env) {
        if (this.table == null) {
            return;
        }
        TSStatus status = env.getConfigManager().getClusterSchemaManager().executePlan(new RenameTableColumnPlan(this.database, this.tableName, this.newName, this.oldName), this.isGeneratedByPipe);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status)));
        }
    }

    @Override
    protected RenameTableColumnState getState(int stateId) {
        return RenameTableColumnState.values()[stateId];
    }

    @Override
    protected int getStateId(RenameTableColumnState state) {
        return state.ordinal();
    }

    @Override
    protected RenameTableColumnState getInitialState() {
        return RenameTableColumnState.COLUMN_CHECK;
    }

    @Override
    protected String getActionMessage() {
        return "rename table column";
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_RENAME_TABLE_COLUMN_PROCEDURE.getTypeCode() : ProcedureType.RENAME_TABLE_COLUMN_PROCEDURE.getTypeCode());
        this.innerSerialize(stream);
    }

    protected void innerSerialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.oldName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.newName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.oldName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.newName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.oldName, ((RenameTableColumnProcedure)o).oldName) && Objects.equals(this.newName, ((RenameTableColumnProcedure)o).newName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.oldName, this.newName);
    }
}

