/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSink;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationLoad {
    public static final ReplicationLoad EMPTY_REPLICATIONLOAD = new ReplicationLoad();
    private MetricsSink sinkMetrics;
    private List<ClusterStatusProtos.ReplicationLoadSource> replicationLoadSourceEntries;
    private ClusterStatusProtos.ReplicationLoadSink replicationLoadSink;

    public void buildReplicationLoad(List<ReplicationSourceInterface> sources, MetricsSink skMetrics) {
        this.sinkMetrics = skMetrics;
        ClusterStatusProtos.ReplicationLoadSink.Builder rLoadSinkBuild = ClusterStatusProtos.ReplicationLoadSink.newBuilder();
        rLoadSinkBuild.setAgeOfLastAppliedOp(this.sinkMetrics.getAgeOfLastAppliedOp());
        rLoadSinkBuild.setTimeStampsOfLastAppliedOp(this.sinkMetrics.getTimestampOfLastAppliedOp());
        rLoadSinkBuild.setTimestampStarted(this.sinkMetrics.getStartTimestamp());
        rLoadSinkBuild.setTotalOpsProcessed(this.sinkMetrics.getAppliedOps());
        this.replicationLoadSink = rLoadSinkBuild.build();
        this.replicationLoadSourceEntries = new ArrayList<ClusterStatusProtos.ReplicationLoadSource>();
        for (ReplicationSourceInterface source : sources) {
            MetricsSource sm = source.getSourceMetrics();
            String peerId = sm.getPeerID();
            String[] parts = peerId.split("-", 2);
            peerId = parts.length != 1 ? parts[0] : peerId;
            long ageOfLastShippedOp = sm.getAgeOfLastShippedOp();
            int sizeOfLogQueue = sm.getSizeOfLogQueue();
            long editsRead = sm.getReplicableEdits();
            long oPsShipped = sm.getOpsShipped();
            long timeStampOfLastShippedOp = sm.getTimestampOfLastShippedOp();
            long timeStampOfNextToReplicate = sm.getTimeStampNextToReplicate();
            long replicationLag = sm.getReplicationDelay();
            ClusterStatusProtos.ReplicationLoadSource.Builder rLoadSourceBuild = ClusterStatusProtos.ReplicationLoadSource.newBuilder();
            rLoadSourceBuild.setPeerID(peerId);
            rLoadSourceBuild.setAgeOfLastShippedOp(ageOfLastShippedOp);
            rLoadSourceBuild.setSizeOfLogQueue(sizeOfLogQueue);
            rLoadSourceBuild.setTimeStampOfLastShippedOp(timeStampOfLastShippedOp);
            rLoadSourceBuild.setReplicationLag(replicationLag);
            rLoadSourceBuild.setTimeStampOfNextToReplicate(timeStampOfNextToReplicate);
            rLoadSourceBuild.setEditsRead(editsRead);
            rLoadSourceBuild.setOPsShipped(oPsShipped);
            if (source instanceof ReplicationSource) {
                ReplicationSource replSource = (ReplicationSource)source;
                rLoadSourceBuild.setRecovered(replSource.getReplicationQueueInfo().isQueueRecovered());
                rLoadSourceBuild.setQueueId(replSource.getReplicationQueueInfo().getQueueId());
                rLoadSourceBuild.setRunning(replSource.isWorkerRunning());
                rLoadSourceBuild.setEditsSinceRestart(timeStampOfNextToReplicate > 0L);
            }
            this.replicationLoadSourceEntries.add(rLoadSourceBuild.build());
        }
    }

    public String sourceToString() {
        StringBuilder sb = new StringBuilder();
        for (ClusterStatusProtos.ReplicationLoadSource rls : this.replicationLoadSourceEntries) {
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"\n           PeerID", (Object)rls.getPeerID());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"AgeOfLastShippedOp", (Object)rls.getAgeOfLastShippedOp());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"SizeOfLogQueue", (Object)rls.getSizeOfLogQueue());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"TimestampsOfLastShippedOp", (Object)new Date(rls.getTimeStampOfLastShippedOp()).toString());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"Replication Lag", (Object)rls.getReplicationLag());
        }
        return sb.toString();
    }

    public String sinkToString() {
        if (this.replicationLoadSink == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"AgeOfLastAppliedOp", (Object)this.replicationLoadSink.getAgeOfLastAppliedOp());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"TimestampsOfLastAppliedOp", (Object)new Date(this.replicationLoadSink.getTimeStampsOfLastAppliedOp()).toString());
        return sb.toString();
    }

    public ClusterStatusProtos.ReplicationLoadSink getReplicationLoadSink() {
        return this.replicationLoadSink;
    }

    public List<ClusterStatusProtos.ReplicationLoadSource> getReplicationLoadSourceEntries() {
        return this.replicationLoadSourceEntries;
    }

    public String toString() {
        return this.sourceToString() + System.getProperty("line.separator") + this.sinkToString();
    }
}

