/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CloseChecker;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestCloseChecker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCloseChecker.class);

    @Test
    public void testIsClosed() {
        Store enableWrite = (Store)Mockito.mock(Store.class);
        Mockito.when((Object)enableWrite.areWritesEnabled()).thenReturn((Object)true);
        Store disableWrite = (Store)Mockito.mock(Store.class);
        Mockito.when((Object)disableWrite.areWritesEnabled()).thenReturn((Object)false);
        Configuration conf = new Configuration();
        long currentTime = System.currentTimeMillis();
        conf.setInt("hbase.hstore.close.check.interval", 10);
        conf.setLong("hbase.hstore.close.check.time.interval", 10L);
        CloseChecker closeChecker = new CloseChecker(conf, currentTime);
        Assert.assertFalse((boolean)closeChecker.isTimeLimit(enableWrite, currentTime));
        Assert.assertFalse((boolean)closeChecker.isSizeLimit(enableWrite, 10L));
        closeChecker = new CloseChecker(conf, currentTime);
        Assert.assertFalse((boolean)closeChecker.isTimeLimit(enableWrite, currentTime + 11L));
        Assert.assertFalse((boolean)closeChecker.isSizeLimit(enableWrite, 11L));
        closeChecker = new CloseChecker(conf, currentTime);
        Assert.assertTrue((boolean)closeChecker.isTimeLimit(disableWrite, currentTime + 11L));
        Assert.assertTrue((boolean)closeChecker.isSizeLimit(disableWrite, 11L));
        for (int i = 0; i < 10; ++i) {
            int plusTime = 5 * i;
            Assert.assertFalse((boolean)closeChecker.isTimeLimit(enableWrite, currentTime + (long)plusTime));
            Assert.assertFalse((boolean)closeChecker.isSizeLimit(enableWrite, 5L));
        }
        closeChecker = new CloseChecker(conf, currentTime);
        Assert.assertFalse((boolean)closeChecker.isTimeLimit(disableWrite, currentTime + 6L));
        Assert.assertFalse((boolean)closeChecker.isSizeLimit(disableWrite, 6L));
        Assert.assertTrue((boolean)closeChecker.isTimeLimit(disableWrite, currentTime + 12L));
        Assert.assertTrue((boolean)closeChecker.isSizeLimit(disableWrite, 6L));
    }
}

