/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsTableAggregateSourceImpl
extends BaseSourceImpl
implements MetricsTableAggregateSource {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsTableAggregateSourceImpl.class);
    private ConcurrentHashMap<String, MetricsTableSource> tableSources = new ConcurrentHashMap();

    public MetricsTableAggregateSourceImpl() {
        this("Tables", "Metrics about HBase RegionServer tables", "regionserver", "RegionServer,sub=Tables");
    }

    public MetricsTableAggregateSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void deleteTableSource(String table) {
        try {
            MetricsTableSource source = this.tableSources.remove(table);
            if (source != null) {
                source.close();
            }
        }
        catch (Exception e) {
            LOG.info("Error trying to remove " + table + " from " + this.getClass().getSimpleName(), (Throwable)e);
        }
    }

    @Override
    public MetricsTableSource getOrCreateTableSource(String table, MetricsTableWrapperAggregate wrapper) {
        MetricsTableSource source = this.tableSources.get(table);
        if (source != null) {
            return source;
        }
        MetricsTableSource newSource = CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).createTable(table, wrapper);
        return this.tableSources.computeIfAbsent(table, k -> {
            newSource.registerMetrics();
            return newSource;
        });
    }

    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder mrb = collector.addRecord(this.metricsName);
        if (this.tableSources != null) {
            for (MetricsTableSource tableMetricSource : this.tableSources.values()) {
                if (!(tableMetricSource instanceof MetricsTableSourceImpl)) continue;
                ((MetricsTableSourceImpl)tableMetricSource).snapshot(mrb, all);
            }
            mrb.addGauge(Interns.info("numTables", "Number of tables in the metrics system"), this.tableSources.size());
            this.metricsRegistry.snapshot(mrb, all);
        }
    }
}

