/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import java.util.Arrays;
import org.apache.cassandra.config.CassandraRelevantEnv;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;

final class SystemPropertiesTable
extends AbstractVirtualTable {
    private static final String NAME = "name";
    private static final String VALUE = "value";

    SystemPropertiesTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "system_properties").comment("Cassandra relevant system properties").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(NAME, UTF8Type.instance).addRegularColumn(VALUE, UTF8Type.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        System.getenv().keySet().stream().filter(SystemPropertiesTable::isCassandraRelevant).forEach(name -> SystemPropertiesTable.addRow(result, name, System.getenv(name)));
        System.getProperties().stringPropertyNames().stream().filter(SystemPropertiesTable::isCassandraRelevant).forEach(name -> SystemPropertiesTable.addRow(result, name, System.getProperty(name)));
        return result;
    }

    @Override
    public AbstractVirtualTable.DataSet data(DecoratedKey partitionKey) {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        String name = (String)UTF8Type.instance.compose(partitionKey.getKey());
        if (SystemPropertiesTable.isCassandraRelevant(name)) {
            SystemPropertiesTable.addRow(result, name, System.getProperty(name, System.getenv(name)));
        }
        return result;
    }

    static boolean isCassandraRelevant(String name) {
        return name.startsWith("cassandra.") || Arrays.stream(CassandraRelevantProperties.values()).anyMatch(p -> p.getKey().equals(name)) || Arrays.stream(CassandraRelevantEnv.values()).anyMatch(p -> p.getKey().equals(name));
    }

    private static void addRow(SimpleDataSet result, String name, String value) {
        result.row(name).column(VALUE, value);
    }
}

