/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class JNDIUtil {
    public static Context createContext(Context c, String path) throws NamingException {
        Context crtContext = c;
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            try {
                Object o = crtContext.lookup(tok);
                if (!(o instanceof Context)) {
                    throw new NamingException("Path " + path + " overwrites and already bound object");
                }
                crtContext = (Context)o;
            }
            catch (NameNotFoundException nameNotFoundException) {
                crtContext = crtContext.createSubcontext(tok);
            }
        }
        return crtContext;
    }

    public static void tearDownRecursively(Context c) throws Exception {
        NamingEnumeration<Binding> ne = c.listBindings("");
        while (ne.hasMore()) {
            Binding b = ne.next();
            String name = b.getName();
            Object object = b.getObject();
            if (object instanceof Context) {
                Context context = (Context)object;
                JNDIUtil.tearDownRecursively(context);
            }
            c.unbind(name);
        }
    }

    public static void rebind(Context c, String jndiName, Object o) throws NamingException {
        Context context = c;
        String name = jndiName;
        int idx = jndiName.lastIndexOf(47);
        if (idx != -1) {
            context = JNDIUtil.createContext(c, jndiName.substring(0, idx));
            name = jndiName.substring(idx + 1);
        }
        boolean failed = false;
        try {
            context.rebind(name, o);
        }
        catch (Exception ignored) {
            failed = true;
        }
        if (failed) {
            context.bind(name, o);
        }
    }
}

