/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.converter;

import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.util.ObjectUtils;

public class SimpleMessageConverter
implements MessageConverter {
    @Override
    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        if (object instanceof Message) {
            Message message = (Message)object;
            return message;
        }
        if (object instanceof String) {
            String text = (String)object;
            return this.createMessageForString(text, session);
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return this.createMessageForByteArray(bytes, session);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.createMessageForMap(map, session);
        }
        if (object instanceof Serializable) {
            Serializable serializable = (Serializable)object;
            return this.createMessageForSerializable(serializable, session);
        }
        throw new MessageConversionException("Cannot convert object of type [" + ObjectUtils.nullSafeClassName((Object)object) + "] to JMS message. Supported message payloads are: String, byte array, Map<String,?>, Serializable object.");
    }

    @Override
    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            return this.extractStringFromMessage(textMessage);
        }
        if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            return this.extractByteArrayFromMessage(bytesMessage);
        }
        if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            return this.extractMapFromMessage(mapMessage);
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            return this.extractSerializableFromMessage(objectMessage);
        }
        return message;
    }

    protected TextMessage createMessageForString(String text, Session session) throws JMSException {
        return session.createTextMessage(text);
    }

    protected BytesMessage createMessageForByteArray(byte[] bytes, Session session) throws JMSException {
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(bytes);
        return message;
    }

    protected MapMessage createMessageForMap(Map<?, ?> map, Session session) throws JMSException {
        MapMessage message = session.createMapMessage();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String)) {
                throw new MessageConversionException("Cannot convert non-String key of type [" + ObjectUtils.nullSafeClassName(key) + "] to JMS MapMessage entry");
            }
            String str = (String)key;
            message.setObject(str, entry.getValue());
        }
        return message;
    }

    protected ObjectMessage createMessageForSerializable(Serializable object, Session session) throws JMSException {
        return session.createObjectMessage(object);
    }

    protected String extractStringFromMessage(TextMessage message) throws JMSException {
        return message.getText();
    }

    protected byte[] extractByteArrayFromMessage(BytesMessage message) throws JMSException {
        byte[] bytes = new byte[(int)message.getBodyLength()];
        message.readBytes(bytes);
        return bytes;
    }

    protected Map<String, Object> extractMapFromMessage(MapMessage message) throws JMSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration en = message.getMapNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            map.put(key, message.getObject(key));
        }
        return map;
    }

    protected Serializable extractSerializableFromMessage(ObjectMessage message) throws JMSException {
        return message.getObject();
    }
}

