/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.PooledObjectFactory;
import org.apache.camel.support.service.ServiceSupport;

public class DefaultExchangeFactoryManager
extends ServiceSupport
implements ExchangeFactoryManager,
CamelContextAware {
    private final Map<Consumer, ExchangeFactory> factories = new ConcurrentHashMap<Consumer, ExchangeFactory>();
    private final UtilizationStatistics statistics = new UtilizationStatistics();
    private CamelContext camelContext;
    private int capacity;
    private boolean statisticsEnabled;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void addExchangeFactory(ExchangeFactory exchangeFactory) {
        this.factories.put(exchangeFactory.getConsumer(), exchangeFactory);
        this.capacity = exchangeFactory.getCapacity();
        this.statisticsEnabled = exchangeFactory.isStatisticsEnabled();
    }

    public void removeExchangeFactory(ExchangeFactory exchangeFactory) {
        this.factories.remove(exchangeFactory.getConsumer());
    }

    public Collection<ExchangeFactory> getExchangeFactories() {
        return Collections.unmodifiableCollection(this.factories.values());
    }

    public int getConsumerCounter() {
        return this.factories.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getPooledCounter() {
        int counter = 0;
        for (ExchangeFactory ef : this.factories.values()) {
            counter += ef.getSize();
        }
        return counter;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        for (ExchangeFactory ef : this.factories.values()) {
            ef.setStatisticsEnabled(statisticsEnabled);
        }
    }

    public void resetStatistics() {
        this.factories.values().forEach(PooledObjectFactory::resetStatistics);
    }

    public void purge() {
        this.factories.values().forEach(PooledObjectFactory::purge);
    }

    public PooledObjectFactory.Statistics getStatistics() {
        return this.statistics;
    }

    protected void doShutdown() throws Exception {
        this.factories.clear();
    }

    final class UtilizationStatistics
    implements PooledObjectFactory.Statistics {
        UtilizationStatistics() {
        }

        public void reset() {
            DefaultExchangeFactoryManager.this.resetStatistics();
        }

        public long getCreatedCounter() {
            long answer = 0L;
            if (DefaultExchangeFactoryManager.this.statisticsEnabled) {
                for (ExchangeFactory ef : DefaultExchangeFactoryManager.this.factories.values()) {
                    answer += ef.getStatistics().getCreatedCounter();
                }
            }
            return answer;
        }

        public long getAcquiredCounter() {
            long answer = 0L;
            if (DefaultExchangeFactoryManager.this.statisticsEnabled) {
                for (ExchangeFactory ef : DefaultExchangeFactoryManager.this.factories.values()) {
                    answer += ef.getStatistics().getAcquiredCounter();
                }
            }
            return answer;
        }

        public long getReleasedCounter() {
            long answer = 0L;
            if (DefaultExchangeFactoryManager.this.statisticsEnabled) {
                for (ExchangeFactory ef : DefaultExchangeFactoryManager.this.factories.values()) {
                    answer += ef.getStatistics().getReleasedCounter();
                }
            }
            return answer;
        }

        public long getDiscardedCounter() {
            long answer = 0L;
            if (DefaultExchangeFactoryManager.this.statisticsEnabled) {
                for (ExchangeFactory ef : DefaultExchangeFactoryManager.this.factories.values()) {
                    answer += ef.getStatistics().getDiscardedCounter();
                }
            }
            return answer;
        }
    }
}

