/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.io.Serializable;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;

public class ThreadPoolProfile
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String id;
    private Boolean defaultProfile;
    private Integer poolSize;
    private Integer maxPoolSize;
    private Long keepAliveTime;
    private TimeUnit timeUnit;
    private Integer maxQueueSize;
    private Boolean allowCoreThreadTimeOut;
    private ThreadPoolRejectedPolicy rejectedPolicy;

    public ThreadPoolProfile() {
    }

    public ThreadPoolProfile(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean isDefaultProfile() {
        return this.defaultProfile != null && this.defaultProfile != false;
    }

    public void setDefaultProfile(Boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public Integer getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public Long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(Long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public Boolean getAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void setAllowCoreThreadTimeOut(Boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    public ThreadPoolRejectedPolicy getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        if (this.rejectedPolicy != null) {
            return this.rejectedPolicy.asRejectedExecutionHandler();
        }
        return null;
    }

    public void setRejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }

    public void addDefaults(ThreadPoolProfile defaultProfile) {
        if (defaultProfile == null) {
            return;
        }
        if (this.poolSize == null) {
            this.poolSize = defaultProfile.getPoolSize();
        }
        if (this.maxPoolSize == null) {
            this.maxPoolSize = defaultProfile.getMaxPoolSize();
        }
        if (this.keepAliveTime == null) {
            this.keepAliveTime = defaultProfile.getKeepAliveTime();
        }
        if (this.timeUnit == null) {
            this.timeUnit = defaultProfile.getTimeUnit();
        }
        if (this.maxQueueSize == null) {
            this.maxQueueSize = defaultProfile.getMaxQueueSize();
        }
        if (this.allowCoreThreadTimeOut == null) {
            this.allowCoreThreadTimeOut = defaultProfile.getAllowCoreThreadTimeOut();
        }
        if (this.rejectedPolicy == null) {
            this.rejectedPolicy = defaultProfile.getRejectedPolicy();
        }
    }

    public boolean isEmpty() {
        return this.poolSize == null && this.maxPoolSize == null && this.keepAliveTime == null && this.timeUnit == null && this.maxQueueSize == null && this.allowCoreThreadTimeOut == null && this.rejectedPolicy == null;
    }

    public ThreadPoolProfile clone() {
        ThreadPoolProfile cloned = new ThreadPoolProfile();
        cloned.setDefaultProfile(this.defaultProfile);
        cloned.setId(this.id);
        cloned.setKeepAliveTime(this.keepAliveTime);
        cloned.setMaxPoolSize(this.maxPoolSize);
        cloned.setMaxQueueSize(this.maxQueueSize);
        cloned.setPoolSize(this.poolSize);
        cloned.setAllowCoreThreadTimeOut(this.allowCoreThreadTimeOut);
        cloned.setRejectedPolicy(this.rejectedPolicy);
        cloned.setTimeUnit(this.timeUnit);
        return cloned;
    }

    public String toString() {
        return "ThreadPoolProfile[" + this.id + " (" + this.defaultProfile + ") size:" + this.poolSize + "-" + this.maxPoolSize + ", keepAlive:" + this.keepAliveTime + " " + String.valueOf((Object)this.timeUnit) + ", maxQueue:" + this.maxQueueSize + ", allowCoreThreadTimeOut:" + this.allowCoreThreadTimeOut + ", rejectedPolicy:" + String.valueOf(this.rejectedPolicy) + "]";
    }
}

