/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.support.DefaultExchange;

public final class ExchangeBuilder {
    private final CamelContext context;
    private ExchangePattern pattern;
    private Object body;
    private final Map<String, Object> headers = new HashMap<String, Object>();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public ExchangeBuilder(CamelContext context) {
        this.context = context;
    }

    public static ExchangeBuilder anExchange(CamelContext context) {
        return new ExchangeBuilder(context);
    }

    public ExchangeBuilder withBody(Object body) {
        this.body = body;
        return this;
    }

    public ExchangeBuilder withHeader(String key, Object value) {
        this.headers.put(key, value);
        return this;
    }

    public ExchangeBuilder withPattern(ExchangePattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public ExchangeBuilder withProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public Exchange build() {
        DefaultExchange exchange = new DefaultExchange(this.context);
        if (this.pattern != null) {
            exchange.setPattern(this.pattern);
        }
        exchange.getMessage().setBody(this.body);
        if (!this.headers.isEmpty()) {
            exchange.getMessage().setHeaders(this.headers);
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            exchange.setProperty(entry.getKey(), entry.getValue());
        }
        return exchange;
    }
}

