/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.history;

import java.io.Serializable;

public class HistoryLimit
implements Serializable {
    private static final long serialVersionUID = 42L;
    private int maxEntries;
    private long maxDuration;

    public HistoryLimit(int pMaxEntries, long pMaxDuration) {
        if (pMaxEntries == 0 && pMaxDuration == 0L) {
            throw new IllegalArgumentException("Invalid limit, either maxEntries or maxDuration must be != 0");
        }
        if (pMaxEntries < 0) {
            throw new IllegalArgumentException("Invalid limit, maxEntries must be >= 0");
        }
        if (pMaxDuration < 0L) {
            throw new IllegalArgumentException("Invalid limit, maxDuration must be >= 0");
        }
        this.maxEntries = pMaxEntries;
        this.maxDuration = pMaxDuration;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public long getMaxDuration() {
        return this.maxDuration;
    }

    public HistoryLimit respectGlobalMaxEntries(int pGlobalMaxEntries) {
        if (this.maxEntries > pGlobalMaxEntries || this.maxEntries == 0) {
            this.maxEntries = pGlobalMaxEntries;
        }
        return this;
    }

    public String toString() {
        return "HistoryLimit{maxEntries=" + this.maxEntries + ", maxDuration=" + this.maxDuration + '}';
    }
}

